package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerStatusFluent<A extends ContainerStatusFluent<A>> extends Fluent<A> {


    public String getContainerID();
    public A withContainerID(String containerID);
    public Boolean hasContainerID();
    public A withNewContainerID(String arg1);
    public A withNewContainerID(StringBuilder arg1);
    public A withNewContainerID(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getImageID();
    public A withImageID(String imageID);
    public Boolean hasImageID();
    public A withNewImageID(String arg1);
    public A withNewImageID(StringBuilder arg1);
    public A withNewImageID(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildLastState instead.
 * @return The buildable object.
 */
@Deprecated public ContainerState getLastState();
    public ContainerState buildLastState();
    public A withLastState(ContainerState lastState);
    public Boolean hasLastState();
    public ContainerStatusFluent.LastStateNested<A> withNewLastState();
    public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item);
    public ContainerStatusFluent.LastStateNested<A> editLastState();
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastState();
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(ContainerState item);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public Boolean isReady();
    public A withReady(Boolean ready);
    public Boolean hasReady();
    public A withNewReady(String arg1);
    public A withNewReady(boolean arg1);
    public Integer getRestartCount();
    public A withRestartCount(Integer restartCount);
    public Boolean hasRestartCount();
    public A withNewRestartCount(String arg1);
    public A withNewRestartCount(int arg1);
    public Boolean isStarted();
    public A withStarted(Boolean started);
    public Boolean hasStarted();
    public A withNewStarted(String arg1);
    public A withNewStarted(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildState instead.
 * @return The buildable object.
 */
@Deprecated public ContainerState getState();
    public ContainerState buildState();
    public A withState(ContainerState state);
    public Boolean hasState();
    public ContainerStatusFluent.StateNested<A> withNewState();
    public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item);
    public ContainerStatusFluent.StateNested<A> editState();
    public ContainerStatusFluent.StateNested<A> editOrNewState();
    public ContainerStatusFluent.StateNested<A> editOrNewStateLike(ContainerState item);
    public interface LastStateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateFluent<ContainerStatusFluent.LastStateNested<N>> {

            public N and();
            public N endLastState();    }


    public interface StateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateFluent<ContainerStatusFluent.StateNested<N>> {

            public N and();
            public N endState();    }


}
