package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ListOptionsFluentImpl<A extends ListOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ListOptionsFluent<A> {

    private Boolean allowWatchBookmarks;
    private String apiVersion;
    private String _continue;
    private String fieldSelector;
    private String kind;
    private String labelSelector;
    private Long limit;
    private String resourceVersion;
    private String resourceVersionMatch;
    private Long timeoutSeconds;
    private Boolean watch;

    public ListOptionsFluentImpl() {
    }

    public ListOptionsFluentImpl(ListOptions instance) {
        this.withAllowWatchBookmarks(instance.getAllowWatchBookmarks()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withContinue(instance.getContinue()); 
        this.withFieldSelector(instance.getFieldSelector()); 
        this.withKind(instance.getKind()); 
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withLimit(instance.getLimit()); 
        this.withResourceVersion(instance.getResourceVersion()); 
        this.withResourceVersionMatch(instance.getResourceVersionMatch()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withWatch(instance.getWatch()); 
    }

    public Boolean isAllowWatchBookmarks() {
        return this.allowWatchBookmarks;
    }

    public A withAllowWatchBookmarks(Boolean allowWatchBookmarks) {
        this.allowWatchBookmarks=allowWatchBookmarks; return (A) this;
    }

    public Boolean hasAllowWatchBookmarks() {
        return this.allowWatchBookmarks != null;
    }

    public A withNewAllowWatchBookmarks(String arg1) {
        return (A)withAllowWatchBookmarks(new Boolean(arg1));
    }

    public A withNewAllowWatchBookmarks(boolean arg1) {
        return (A)withAllowWatchBookmarks(new Boolean(arg1));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getContinue() {
        return this._continue;
    }

    public A withContinue(String _continue) {
        this._continue=_continue; return (A) this;
    }

    public Boolean hasContinue() {
        return this._continue != null;
    }

    public A withNewContinue(String arg1) {
        return (A)withContinue(new String(arg1));
    }

    public A withNewContinue(StringBuilder arg1) {
        return (A)withContinue(new String(arg1));
    }

    public A withNewContinue(StringBuffer arg1) {
        return (A)withContinue(new String(arg1));
    }

    public String getFieldSelector() {
        return this.fieldSelector;
    }

    public A withFieldSelector(String fieldSelector) {
        this.fieldSelector=fieldSelector; return (A) this;
    }

    public Boolean hasFieldSelector() {
        return this.fieldSelector != null;
    }

    public A withNewFieldSelector(String arg1) {
        return (A)withFieldSelector(new String(arg1));
    }

    public A withNewFieldSelector(StringBuilder arg1) {
        return (A)withFieldSelector(new String(arg1));
    }

    public A withNewFieldSelector(StringBuffer arg1) {
        return (A)withFieldSelector(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(String labelSelector) {
        this.labelSelector=labelSelector; return (A) this;
    }

    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public A withNewLabelSelector(String arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(StringBuilder arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(StringBuffer arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public Long getLimit() {
        return this.limit;
    }

    public A withLimit(Long limit) {
        this.limit=limit; return (A) this;
    }

    public Boolean hasLimit() {
        return this.limit != null;
    }

    public A withNewLimit(String arg1) {
        return (A)withLimit(new Long(arg1));
    }

    public A withNewLimit(long arg1) {
        return (A)withLimit(new Long(arg1));
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public A withNewResourceVersion(String arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuilder arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public String getResourceVersionMatch() {
        return this.resourceVersionMatch;
    }

    public A withResourceVersionMatch(String resourceVersionMatch) {
        this.resourceVersionMatch=resourceVersionMatch; return (A) this;
    }

    public Boolean hasResourceVersionMatch() {
        return this.resourceVersionMatch != null;
    }

    public A withNewResourceVersionMatch(String arg1) {
        return (A)withResourceVersionMatch(new String(arg1));
    }

    public A withNewResourceVersionMatch(StringBuilder arg1) {
        return (A)withResourceVersionMatch(new String(arg1));
    }

    public A withNewResourceVersionMatch(StringBuffer arg1) {
        return (A)withResourceVersionMatch(new String(arg1));
    }

    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public A withNewTimeoutSeconds(String arg1) {
        return (A)withTimeoutSeconds(new Long(arg1));
    }

    public A withNewTimeoutSeconds(long arg1) {
        return (A)withTimeoutSeconds(new Long(arg1));
    }

    public Boolean isWatch() {
        return this.watch;
    }

    public A withWatch(Boolean watch) {
        this.watch=watch; return (A) this;
    }

    public Boolean hasWatch() {
        return this.watch != null;
    }

    public A withNewWatch(String arg1) {
        return (A)withWatch(new Boolean(arg1));
    }

    public A withNewWatch(boolean arg1) {
        return (A)withWatch(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ListOptionsFluentImpl that = (ListOptionsFluentImpl) o;
        if (allowWatchBookmarks != null ? !allowWatchBookmarks.equals(that.allowWatchBookmarks) :that.allowWatchBookmarks != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (_continue != null ? !_continue.equals(that._continue) :that._continue != null) return false;
        if (fieldSelector != null ? !fieldSelector.equals(that.fieldSelector) :that.fieldSelector != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        if (limit != null ? !limit.equals(that.limit) :that.limit != null) return false;
        if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
        if (resourceVersionMatch != null ? !resourceVersionMatch.equals(that.resourceVersionMatch) :that.resourceVersionMatch != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        if (watch != null ? !watch.equals(that.watch) :that.watch != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowWatchBookmarks,  apiVersion,  _continue,  fieldSelector,  kind,  labelSelector,  limit,  resourceVersion,  resourceVersionMatch,  timeoutSeconds,  watch,  super.hashCode());
    }

}
