package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ObjectMetaFluent<A extends ObjectMetaFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public String getClusterName();
    public A withClusterName(String clusterName);
    public Boolean hasClusterName();
    public A withNewClusterName(String arg1);
    public A withNewClusterName(StringBuilder arg1);
    public A withNewClusterName(StringBuffer arg1);
    public String getCreationTimestamp();
    public A withCreationTimestamp(String creationTimestamp);
    public Boolean hasCreationTimestamp();
    public A withNewCreationTimestamp(String arg1);
    public A withNewCreationTimestamp(StringBuilder arg1);
    public A withNewCreationTimestamp(StringBuffer arg1);
    public Long getDeletionGracePeriodSeconds();
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds);
    public Boolean hasDeletionGracePeriodSeconds();
    public A withNewDeletionGracePeriodSeconds(String arg1);
    public A withNewDeletionGracePeriodSeconds(long arg1);
    public String getDeletionTimestamp();
    public A withDeletionTimestamp(String deletionTimestamp);
    public Boolean hasDeletionTimestamp();
    public A withNewDeletionTimestamp(String arg1);
    public A withNewDeletionTimestamp(StringBuilder arg1);
    public A withNewDeletionTimestamp(StringBuffer arg1);
    public A addToFinalizers(int index,String item);
    public A setToFinalizers(int index,String item);
    public A addToFinalizers(String... items);
    public A addAllToFinalizers(Collection<String> items);
    public A removeFromFinalizers(String... items);
    public A removeAllFromFinalizers(Collection<String> items);
    public List<String> getFinalizers();
    public String getFinalizer(int index);
    public String getFirstFinalizer();
    public String getLastFinalizer();
    public String getMatchingFinalizer(Predicate<String> predicate);
    public Boolean hasMatchingFinalizer(Predicate<String> predicate);
    public A withFinalizers(List<String> finalizers);
    public A withFinalizers(String... finalizers);
    public Boolean hasFinalizers();
    public A addNewFinalizer(String arg1);
    public A addNewFinalizer(StringBuilder arg1);
    public A addNewFinalizer(StringBuffer arg1);
    public String getGenerateName();
    public A withGenerateName(String generateName);
    public Boolean hasGenerateName();
    public A withNewGenerateName(String arg1);
    public A withNewGenerateName(StringBuilder arg1);
    public A withNewGenerateName(StringBuffer arg1);
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    public A withNewGeneration(String arg1);
    public A withNewGeneration(long arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToManagedFields(int index,ManagedFieldsEntry item);
    public A setToManagedFields(int index,ManagedFieldsEntry item);
    public A addToManagedFields(ManagedFieldsEntry... items);
    public A addAllToManagedFields(Collection<ManagedFieldsEntry> items);
    public A removeFromManagedFields(ManagedFieldsEntry... items);
    public A removeAllFromManagedFields(Collection<ManagedFieldsEntry> items);
    public A removeMatchingFromManagedFields(Predicate<ManagedFieldsEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildManagedFields instead.
 * @return The buildable object.
 */
@Deprecated public List<ManagedFieldsEntry> getManagedFields();
    public List<ManagedFieldsEntry> buildManagedFields();
    public ManagedFieldsEntry buildManagedField(int index);
    public ManagedFieldsEntry buildFirstManagedField();
    public ManagedFieldsEntry buildLastManagedField();
    public ManagedFieldsEntry buildMatchingManagedField(Predicate<ManagedFieldsEntryBuilder> predicate);
    public Boolean hasMatchingManagedField(Predicate<ManagedFieldsEntryBuilder> predicate);
    public A withManagedFields(List<ManagedFieldsEntry> managedFields);
    public A withManagedFields(ManagedFieldsEntry... managedFields);
    public Boolean hasManagedFields();
    public ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedField();
    public ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedFieldLike(ManagedFieldsEntry item);
    public ObjectMetaFluent.ManagedFieldsNested<A> setNewManagedFieldLike(int index,ManagedFieldsEntry item);
    public ObjectMetaFluent.ManagedFieldsNested<A> editManagedField(int index);
    public ObjectMetaFluent.ManagedFieldsNested<A> editFirstManagedField();
    public ObjectMetaFluent.ManagedFieldsNested<A> editLastManagedField();
    public ObjectMetaFluent.ManagedFieldsNested<A> editMatchingManagedField(Predicate<ManagedFieldsEntryBuilder> predicate);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public A addToOwnerReferences(int index,OwnerReference item);
    public A setToOwnerReferences(int index,OwnerReference item);
    public A addToOwnerReferences(OwnerReference... items);
    public A addAllToOwnerReferences(Collection<OwnerReference> items);
    public A removeFromOwnerReferences(OwnerReference... items);
    public A removeAllFromOwnerReferences(Collection<OwnerReference> items);
    public A removeMatchingFromOwnerReferences(Predicate<OwnerReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildOwnerReferences instead.
 * @return The buildable object.
 */
@Deprecated public List<OwnerReference> getOwnerReferences();
    public List<OwnerReference> buildOwnerReferences();
    public OwnerReference buildOwnerReference(int index);
    public OwnerReference buildFirstOwnerReference();
    public OwnerReference buildLastOwnerReference();
    public OwnerReference buildMatchingOwnerReference(Predicate<OwnerReferenceBuilder> predicate);
    public Boolean hasMatchingOwnerReference(Predicate<OwnerReferenceBuilder> predicate);
    public A withOwnerReferences(List<OwnerReference> ownerReferences);
    public A withOwnerReferences(OwnerReference... ownerReferences);
    public Boolean hasOwnerReferences();
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference();
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(OwnerReference item);
    public ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(int index,OwnerReference item);
    public ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(int index);
    public ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference();
    public ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference();
    public ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(Predicate<OwnerReferenceBuilder> predicate);
    public String getResourceVersion();
    public A withResourceVersion(String resourceVersion);
    public Boolean hasResourceVersion();
    public A withNewResourceVersion(String arg1);
    public A withNewResourceVersion(StringBuilder arg1);
    public A withNewResourceVersion(StringBuffer arg1);
    public String getSelfLink();
    public A withSelfLink(String selfLink);
    public Boolean hasSelfLink();
    public A withNewSelfLink(String arg1);
    public A withNewSelfLink(StringBuilder arg1);
    public A withNewSelfLink(StringBuffer arg1);
    public String getUid();
    public A withUid(String uid);
    public Boolean hasUid();
    public A withNewUid(String arg1);
    public A withNewUid(StringBuilder arg1);
    public A withNewUid(StringBuffer arg1);
    public interface ManagedFieldsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ManagedFieldsEntryFluent<ObjectMetaFluent.ManagedFieldsNested<N>> {

            public N and();
            public N endManagedField();    }


    public interface OwnerReferencesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OwnerReferenceFluent<ObjectMetaFluent.OwnerReferencesNested<N>> {

            public N and();
            public N endOwnerReference();    }


}
