package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface ServicePortFluent<A extends ServicePortFluent<A>> extends Fluent<A> {


    public String getAppProtocol();
    public A withAppProtocol(String appProtocol);
    public Boolean hasAppProtocol();
    public A withNewAppProtocol(String arg1);
    public A withNewAppProtocol(StringBuilder arg1);
    public A withNewAppProtocol(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public Integer getNodePort();
    public A withNodePort(Integer nodePort);
    public Boolean hasNodePort();
    public A withNewNodePort(String arg1);
    public A withNewNodePort(int arg1);
    public Integer getPort();
    public A withPort(Integer port);
    public Boolean hasPort();
    public A withNewPort(String arg1);
    public A withNewPort(int arg1);
    public String getProtocol();
    public A withProtocol(String protocol);
    public Boolean hasProtocol();
    public A withNewProtocol(String arg1);
    public A withNewProtocol(StringBuilder arg1);
    public A withNewProtocol(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTargetPort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getTargetPort();
    public IntOrString buildTargetPort();
    public A withTargetPort(IntOrString targetPort);
    public Boolean hasTargetPort();
    public A withNewTargetPort(String strVal);
    public A withNewTargetPort(Integer intVal);
    public ServicePortFluent.TargetPortNested<A> withNewTargetPort();
    public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item);
    public ServicePortFluent.TargetPortNested<A> editTargetPort();
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPort();
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item);
    public interface TargetPortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntOrStringFluent<ServicePortFluent.TargetPortNested<N>> {

            public N and();
            public N endTargetPort();    }


}
