package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NodeConfigSourceBuilder extends io.fabric8.kubernetes.api.model.NodeConfigSourceFluentImpl<io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeConfigSource,io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder>{
  public NodeConfigSourceBuilder() {
    this(false);
  }
  public NodeConfigSourceBuilder(java.lang.Boolean validationEnabled) {
    this(new NodeConfigSource(), validationEnabled);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeConfigSource(), validationEnabled);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeConfigSource instance) {
    this(fluent, instance, false);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeConfigSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSource instance) {
    this(instance,false);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeConfigSource build() {
    NodeConfigSource buildable = new NodeConfigSource(fluent.getConfigMap());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeConfigSourceBuilder that = (NodeConfigSourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}