package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class ClusterFluentImpl<A extends io.fabric8.kubernetes.api.model.ClusterFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ClusterFluent<A>{
  public ClusterFluentImpl() {
  }
  public ClusterFluentImpl(io.fabric8.kubernetes.api.model.Cluster instance) {
    this.withCertificateAuthority(instance.getCertificateAuthority()); 
    this.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
    this.withExtensions(instance.getExtensions()); 
    this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withServer(instance.getServer()); 
    this.withTlsServerName(instance.getTlsServerName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String certificateAuthority;
  private java.lang.String certificateAuthorityData;
  private java.util.List<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> extensions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();
  private java.lang.Boolean insecureSkipTlsVerify;
  private java.lang.String proxyUrl;
  private java.lang.String server;
  private java.lang.String tlsServerName;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getCertificateAuthority() {
    return this.certificateAuthority;
  }
  public A withCertificateAuthority(java.lang.String certificateAuthority) {
    this.certificateAuthority=certificateAuthority; return (A) this;
  }
  public java.lang.Boolean hasCertificateAuthority() {
    return this.certificateAuthority != null;
  }
  
  /**
   * Method is deprecated. use withCertificateAuthority instead.
   */
  @java.lang.Deprecated
  public A withNewCertificateAuthority(java.lang.String arg0) {
    return (A)withCertificateAuthority(new String(arg0));
  }
  public java.lang.String getCertificateAuthorityData() {
    return this.certificateAuthorityData;
  }
  public A withCertificateAuthorityData(java.lang.String certificateAuthorityData) {
    this.certificateAuthorityData=certificateAuthorityData; return (A) this;
  }
  public java.lang.Boolean hasCertificateAuthorityData() {
    return this.certificateAuthorityData != null;
  }
  
  /**
   * Method is deprecated. use withCertificateAuthorityData instead.
   */
  @java.lang.Deprecated
  public A withNewCertificateAuthorityData(java.lang.String arg0) {
    return (A)withCertificateAuthorityData(new String(arg0));
  }
  public A addToExtensions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(index >= 0 ? index : _visitables.get("extensions").size(), builder);this.extensions.add(index >= 0 ? index : extensions.size(), builder); return (A)this;
  }
  public A setToExtensions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);
    if (index < 0 || index >= _visitables.get("extensions").size()) { _visitables.get("extensions").add(builder); } else { _visitables.get("extensions").set(index, builder);}
    if (index < 0 || index >= extensions.size()) { extensions.add(builder); } else { extensions.set(index, builder);}
     return (A)this;
  }
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A addAllToExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedExtensionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtensions(java.util.Collection<io.fabric8.kubernetes.api.model.NamedExtension> items) {
    for (io.fabric8.kubernetes.api.model.NamedExtension item : items) {io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtensions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> getExtensions() {
    return build(extensions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> buildExtensions() {
    return build(extensions);
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildExtension(java.lang.Integer index) {
    return this.extensions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NamedExtension buildMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtensions(java.util.List<io.fabric8.kubernetes.api.model.NamedExtension> extensions) {
    if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
    if (extensions != null) {this.extensions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
  }
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {this.extensions.clear();}
    if (extensions != null) {for (io.fabric8.kubernetes.api.model.NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
  }
  public java.lang.Boolean hasExtensions() {
    return extensions != null && !extensions.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> addNewExtension() {
    return new io.fabric8.kubernetes.api.model.ClusterFluentImpl.ExtensionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> addNewExtensionLike(io.fabric8.kubernetes.api.model.NamedExtension item) {
    return new io.fabric8.kubernetes.api.model.ClusterFluentImpl.ExtensionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> setNewExtensionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
    return new io.fabric8.kubernetes.api.model.ClusterFluentImpl.ExtensionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> editExtension(java.lang.Integer index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<A> editMatchingExtension(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public java.lang.Boolean getInsecureSkipTlsVerify() {
    return this.insecureSkipTlsVerify;
  }
  public A withInsecureSkipTlsVerify(java.lang.Boolean insecureSkipTlsVerify) {
    this.insecureSkipTlsVerify=insecureSkipTlsVerify; return (A) this;
  }
  public java.lang.Boolean hasInsecureSkipTlsVerify() {
    return this.insecureSkipTlsVerify != null;
  }
  public java.lang.String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(java.lang.String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public java.lang.Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  /**
   * Method is deprecated. use withProxyUrl instead.
   */
  @java.lang.Deprecated
  public A withNewProxyUrl(java.lang.String arg0) {
    return (A)withProxyUrl(new String(arg0));
  }
  public java.lang.String getServer() {
    return this.server;
  }
  public A withServer(java.lang.String server) {
    this.server=server; return (A) this;
  }
  public java.lang.Boolean hasServer() {
    return this.server != null;
  }
  
  /**
   * Method is deprecated. use withServer instead.
   */
  @java.lang.Deprecated
  public A withNewServer(java.lang.String arg0) {
    return (A)withServer(new String(arg0));
  }
  public java.lang.String getTlsServerName() {
    return this.tlsServerName;
  }
  public A withTlsServerName(java.lang.String tlsServerName) {
    this.tlsServerName=tlsServerName; return (A) this;
  }
  public java.lang.Boolean hasTlsServerName() {
    return this.tlsServerName != null;
  }
  
  /**
   * Method is deprecated. use withTlsServerName instead.
   */
  @java.lang.Deprecated
  public A withNewTlsServerName(java.lang.String arg0) {
    return (A)withTlsServerName(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterFluentImpl that = (ClusterFluentImpl) o;
    if (certificateAuthority != null ? !certificateAuthority.equals(that.certificateAuthority) :that.certificateAuthority != null) return false;
    if (certificateAuthorityData != null ? !certificateAuthorityData.equals(that.certificateAuthorityData) :that.certificateAuthorityData != null) return false;
    if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
    if (insecureSkipTlsVerify != null ? !insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) :that.insecureSkipTlsVerify != null) return false;
    if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
    if (server != null ? !server.equals(that.server) :that.server != null) return false;
    if (tlsServerName != null ? !tlsServerName.equals(that.tlsServerName) :that.tlsServerName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(certificateAuthority,  certificateAuthorityData,  extensions,  insecureSkipTlsVerify,  proxyUrl,  server,  tlsServerName,  additionalProperties,  super.hashCode());
  }
  public class ExtensionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl<io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<N>> implements io.fabric8.kubernetes.api.model.ClusterFluent.ExtensionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ExtensionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamedExtension item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(this, item);
    }
    ExtensionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamedExtensionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamedExtensionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterFluentImpl.this.setToExtensions(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  
}