package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class GroupVersionKindBuilder extends io.fabric8.kubernetes.api.model.GroupVersionKindFluentImpl<io.fabric8.kubernetes.api.model.GroupVersionKindBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.GroupVersionKind,io.fabric8.kubernetes.api.model.GroupVersionKindBuilder>{
  public GroupVersionKindBuilder() {
    this(false);
  }
  public GroupVersionKindBuilder(java.lang.Boolean validationEnabled) {
    this(new GroupVersionKind(), validationEnabled);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupVersionKind(), validationEnabled);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionKind instance) {
    this(fluent, instance, false);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent,io.fabric8.kubernetes.api.model.GroupVersionKind instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKind instance) {
    this(instance,false);
  }
  public GroupVersionKindBuilder(io.fabric8.kubernetes.api.model.GroupVersionKind instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.GroupVersionKindFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.GroupVersionKind build() {
    GroupVersionKind buildable = new GroupVersionKind(fluent.getGroup(),fluent.getKind(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GroupVersionKindBuilder that = (GroupVersionKindBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}