package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TolerationBuilder extends io.fabric8.kubernetes.api.model.TolerationFluentImpl<io.fabric8.kubernetes.api.model.TolerationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Toleration,io.fabric8.kubernetes.api.model.TolerationBuilder>{
  public TolerationBuilder() {
    this(false);
  }
  public TolerationBuilder(java.lang.Boolean validationEnabled) {
    this(new Toleration(), validationEnabled);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent) {
    this(fluent, false);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Toleration(), validationEnabled);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent,io.fabric8.kubernetes.api.model.Toleration instance) {
    this(fluent, instance, false);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent,io.fabric8.kubernetes.api.model.Toleration instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEffect(instance.getEffect()); 
    fluent.withKey(instance.getKey()); 
    fluent.withOperator(instance.getOperator()); 
    fluent.withTolerationSeconds(instance.getTolerationSeconds()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.Toleration instance) {
    this(instance,false);
  }
  public TolerationBuilder(io.fabric8.kubernetes.api.model.Toleration instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEffect(instance.getEffect()); 
    this.withKey(instance.getKey()); 
    this.withOperator(instance.getOperator()); 
    this.withTolerationSeconds(instance.getTolerationSeconds()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TolerationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Toleration build() {
    Toleration buildable = new Toleration(fluent.getEffect(),fluent.getKey(),fluent.getOperator(),fluent.getTolerationSeconds(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TolerationBuilder that = (TolerationBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}