package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CephFSVolumeSourceFluentImpl<A extends CephFSVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CephFSVolumeSourceFluent<A> {

    private List<String> monitors = new ArrayList<String>();
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private LocalObjectReferenceBuilder secretRef;
    private String user;

    public CephFSVolumeSourceFluentImpl() {
    }

    public CephFSVolumeSourceFluentImpl(CephFSVolumeSource instance) {
        this.withMonitors(instance.getMonitors()); 
        this.withPath(instance.getPath()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretFile(instance.getSecretFile()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withUser(instance.getUser()); 
    }

    public A addToMonitors(int index,String item) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        this.monitors.add(index, item);
        return (A)this;
    }

    public A setToMonitors(int index,String item) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        this.monitors.set(index, item); return (A)this;
    }

    public A addToMonitors(String... items) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        for (String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        for (String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A removeFromMonitors(String... items) {
        for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    public String getLastMonitor() {
        return this.monitors.get(monitors.size() - 1);
    }

    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item: monitors) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item: monitors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMonitors(List<String> monitors) {
        if (this.monitors != null) { _visitables.get("monitors").removeAll(this.monitors);}
        if (monitors != null) {this.monitors = new ArrayList<String>(); for (String item : monitors){this.addToMonitors(item);}} else { this.monitors = null;} return (A) this;
    }

    public A withMonitors(String... monitors) {
        if (this.monitors != null) {this.monitors.clear();}
        if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (A) this;
    }

    public Boolean hasMonitors() {
        return monitors != null && !monitors.isEmpty();
    }

    public A addNewMonitor(StringBuilder arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(int[] arg1,int arg2,int arg3) {
        return (A)addToMonitors(new String(arg1, arg2, arg3));
    }

    public A addNewMonitor(char[] arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(StringBuffer arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(byte[] arg1,int arg2) {
        return (A)addToMonitors(new String(arg1, arg2));
    }

    public A addNewMonitor(byte[] arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(char[] arg1,int arg2,int arg3) {
        return (A)addToMonitors(new String(arg1, arg2, arg3));
    }

    public A addNewMonitor(byte[] arg1,int arg2,int arg3) {
        return (A)addToMonitors(new String(arg1, arg2, arg3));
    }

    public A addNewMonitor(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToMonitors(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewMonitor(String arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(int[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(char[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(byte[] arg1,int arg2) {
        return (A)withPath(new String(arg1, arg2));
    }

    public A withNewPath(byte[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(char[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public String getSecretFile() {
        return this.secretFile;
    }

    public A withSecretFile(String secretFile) {
        this.secretFile=secretFile; return (A) this;
    }

    public Boolean hasSecretFile() {
        return this.secretFile != null;
    }

    public A withNewSecretFile(StringBuilder arg1) {
        return (A)withSecretFile(new String(arg1));
    }

    public A withNewSecretFile(int[] arg1,int arg2,int arg3) {
        return (A)withSecretFile(new String(arg1, arg2, arg3));
    }

    public A withNewSecretFile(char[] arg1) {
        return (A)withSecretFile(new String(arg1));
    }

    public A withNewSecretFile(StringBuffer arg1) {
        return (A)withSecretFile(new String(arg1));
    }

    public A withNewSecretFile(byte[] arg1,int arg2) {
        return (A)withSecretFile(new String(arg1, arg2));
    }

    public A withNewSecretFile(byte[] arg1) {
        return (A)withSecretFile(new String(arg1));
    }

    public A withNewSecretFile(char[] arg1,int arg2,int arg3) {
        return (A)withSecretFile(new String(arg1, arg2, arg3));
    }

    public A withNewSecretFile(byte[] arg1,int arg2,int arg3) {
        return (A)withSecretFile(new String(arg1, arg2, arg3));
    }

    public A withNewSecretFile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSecretFile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSecretFile(String arg1) {
        return (A)withSecretFile(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public LocalObjectReference buildSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(LocalObjectReference secretRef) {
        _visitables.get("secretRef").remove(this.secretRef);
        if (secretRef!=null){ this.secretRef= new LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String name) {
        return (A)withSecretRef(new LocalObjectReference(name));
    }

    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    public CephFSVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return withNewSecretRefLike(getSecretRef());
    }

    public CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new LocalObjectReferenceBuilder().build());
    }

    public CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user=user; return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(StringBuilder arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(int[] arg1,int arg2,int arg3) {
        return (A)withUser(new String(arg1, arg2, arg3));
    }

    public A withNewUser(char[] arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(byte[] arg1,int arg2) {
        return (A)withUser(new String(arg1, arg2));
    }

    public A withNewUser(byte[] arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(char[] arg1,int arg2,int arg3) {
        return (A)withUser(new String(arg1, arg2, arg3));
    }

    public A withNewUser(byte[] arg1,int arg2,int arg3) {
        return (A)withUser(new String(arg1, arg2, arg3));
    }

    public A withNewUser(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUser(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUser(String arg1) {
        return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CephFSVolumeSourceFluentImpl that = (CephFSVolumeSourceFluentImpl) o;
        if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (secretFile != null ? !secretFile.equals(that.secretFile) :that.secretFile != null) return false;
        if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(monitors,  path,  readOnly,  secretFile,  secretRef,  user,  super.hashCode());
    }

    public class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<CephFSVolumeSourceFluent.SecretRefNested<N>> implements CephFSVolumeSourceFluent.SecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;

            SecretRefNestedImpl(LocalObjectReference item) {
                this.builder = new LocalObjectReferenceBuilder(this, item);
                        
            }

            SecretRefNestedImpl() {
                this.builder = new LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) CephFSVolumeSourceFluentImpl.this.withSecretRef(builder.build());
            }

            public N endSecretRef() {
                return and();
            }
    }


}
