package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConditionBuilder extends ConditionFluentImpl<ConditionBuilder> implements VisitableBuilder<Condition,ConditionBuilder> {

    ConditionFluent<?> fluent;
    Boolean validationEnabled;

    public ConditionBuilder() {
        this(true);
    }

    public ConditionBuilder(Boolean validationEnabled) {
        this(new Condition(), validationEnabled);
    }

    public ConditionBuilder(ConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public ConditionBuilder(ConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Condition(), validationEnabled);
    }

    public ConditionBuilder(ConditionFluent<?> fluent,Condition instance) {
        this(fluent, instance, true);
    }

    public ConditionBuilder(ConditionFluent<?> fluent,Condition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConditionBuilder(Condition instance) {
        this(instance,true);
    }

    public ConditionBuilder(Condition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public Condition build() {
        Condition buildable = new Condition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConditionBuilder that = (ConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
