package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PatchBuilder extends PatchFluentImpl<PatchBuilder> implements VisitableBuilder<Patch,PatchBuilder> {

    PatchFluent<?> fluent;
    Boolean validationEnabled;

    public PatchBuilder() {
        this(true);
    }

    public PatchBuilder(Boolean validationEnabled) {
        this(new Patch(), validationEnabled);
    }

    public PatchBuilder(PatchFluent<?> fluent) {
        this(fluent, true);
    }

    public PatchBuilder(PatchFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Patch(), validationEnabled);
    }

    public PatchBuilder(PatchFluent<?> fluent,Patch instance) {
        this(fluent, instance, true);
    }

    public PatchBuilder(PatchFluent<?> fluent,Patch instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public PatchBuilder(Patch instance) {
        this(instance,true);
    }

    public PatchBuilder(Patch instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public Patch build() {
        Patch buildable = new Patch();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PatchBuilder that = (PatchBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
