package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PatchOptionsBuilder extends PatchOptionsFluentImpl<PatchOptionsBuilder> implements VisitableBuilder<PatchOptions,PatchOptionsBuilder> {

    PatchOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public PatchOptionsBuilder() {
        this(true);
    }

    public PatchOptionsBuilder(Boolean validationEnabled) {
        this(new PatchOptions(), validationEnabled);
    }

    public PatchOptionsBuilder(PatchOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PatchOptions(), validationEnabled);
    }

    public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,PatchOptions instance) {
        this(fluent, instance, true);
    }

    public PatchOptionsBuilder(PatchOptionsFluent<?> fluent,PatchOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDryRun(instance.getDryRun()); 
        fluent.withFieldManager(instance.getFieldManager()); 
        fluent.withForce(instance.getForce()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public PatchOptionsBuilder(PatchOptions instance) {
        this(instance,true);
    }

    public PatchOptionsBuilder(PatchOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDryRun(instance.getDryRun()); 
        this.withFieldManager(instance.getFieldManager()); 
        this.withForce(instance.getForce()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public PatchOptions build() {
        PatchOptions buildable = new PatchOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getForce(),fluent.getKind());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PatchOptionsBuilder that = (PatchOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
