package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LifecycleBuilder extends LifecycleFluentImpl<LifecycleBuilder> implements VisitableBuilder<Lifecycle,LifecycleBuilder> {

    LifecycleFluent<?> fluent;
    Boolean validationEnabled;

    public LifecycleBuilder() {
        this(true);
    }

    public LifecycleBuilder(Boolean validationEnabled) {
        this(new Lifecycle(), validationEnabled);
    }

    public LifecycleBuilder(LifecycleFluent<?> fluent) {
        this(fluent, true);
    }

    public LifecycleBuilder(LifecycleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Lifecycle(), validationEnabled);
    }

    public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance) {
        this(fluent, instance, true);
    }

    public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPostStart(instance.getPostStart()); 
        fluent.withPreStop(instance.getPreStop()); 
        this.validationEnabled = validationEnabled; 
    }

    public LifecycleBuilder(Lifecycle instance) {
        this(instance,true);
    }

    public LifecycleBuilder(Lifecycle instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPostStart(instance.getPostStart()); 
        this.withPreStop(instance.getPreStop()); 
        this.validationEnabled = validationEnabled; 
    }

    public Lifecycle build() {
        Lifecycle buildable = new Lifecycle(fluent.getPostStart(),fluent.getPreStop());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LifecycleBuilder that = (LifecycleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
