package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class LocalVolumeSourceFluentImpl<A extends LocalVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LocalVolumeSourceFluent<A> {

    private String fsType;
    private String path;

    public LocalVolumeSourceFluentImpl() {
    }

    public LocalVolumeSourceFluentImpl(LocalVolumeSource instance) {
        this.withFsType(instance.getFsType()); 
        this.withPath(instance.getPath()); 
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType() {
        return this.fsType != null;
    }

    public A withNewFsType(StringBuilder arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(int[] arg1,int arg2,int arg3) {
        return (A)withFsType(new String(arg1, arg2, arg3));
    }

    public A withNewFsType(char[] arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(byte[] arg1,int arg2) {
        return (A)withFsType(new String(arg1, arg2));
    }

    public A withNewFsType(byte[] arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(char[] arg1,int arg2,int arg3) {
        return (A)withFsType(new String(arg1, arg2, arg3));
    }

    public A withNewFsType(byte[] arg1,int arg2,int arg3) {
        return (A)withFsType(new String(arg1, arg2, arg3));
    }

    public A withNewFsType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFsType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFsType(String arg1) {
        return (A)withFsType(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(int[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(char[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(byte[] arg1,int arg2) {
        return (A)withPath(new String(arg1, arg2));
    }

    public A withNewPath(byte[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(char[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LocalVolumeSourceFluentImpl that = (LocalVolumeSourceFluentImpl) o;
        if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsType,  path,  super.hashCode());
    }

}
