package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Deprecated;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedExtensionFluentImpl<A extends NamedExtensionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamedExtensionFluent<A> {

    private VisitableBuilder<? extends HasMetadata,?> extension;
    private String name;

    public NamedExtensionFluentImpl() {
    }

    public NamedExtensionFluentImpl(NamedExtension instance) {
        this.withExtension(instance.getExtension()); 
        this.withName(instance.getName()); 
    }

    
/**
 * This method has been deprecated, please use method buildExtension instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getExtension() {
        return this.extension!=null?this.extension.build():null;
    }

    public HasMetadata buildExtension() {
        return this.extension!=null?this.extension.build():null;
    }

    public A withExtension(HasMetadata extension) {
        if (extension instanceof LimitRange){ this.extension= new LimitRangeBuilder((LimitRange)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof APIService){ this.extension= new APIServiceBuilder((APIService)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Namespace){ this.extension= new NamespaceBuilder((Namespace)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Service){ this.extension= new ServiceBuilder((Service)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ReplicationController){ this.extension= new ReplicationControllerBuilder((ReplicationController)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof PodTemplate){ this.extension= new PodTemplateBuilder((PodTemplate)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Event){ this.extension= new EventBuilder((Event)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof PersistentVolume){ this.extension= new PersistentVolumeBuilder((PersistentVolume)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof PersistentVolumeClaim){ this.extension= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Endpoints){ this.extension= new EndpointsBuilder((Endpoints)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Pod){ this.extension= new PodBuilder((Pod)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ConfigMap){ this.extension= new ConfigMapBuilder((ConfigMap)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ComponentStatus){ this.extension= new ComponentStatusBuilder((ComponentStatus)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Binding){ this.extension= new BindingBuilder((Binding)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ResourceQuota){ this.extension= new ResourceQuotaBuilder((ResourceQuota)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Secret){ this.extension= new SecretBuilder((Secret)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Node){ this.extension= new NodeBuilder((Node)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ServiceAccount){ this.extension= new ServiceAccountBuilder((ServiceAccount)extension); _visitables.get("extension").add(this.extension);}
        return (A) this;
    }

    public Boolean hasExtension() {
        return this.extension != null;
    }

    public A withLimitRangeExtension(LimitRange limitRangeExtension) {
        _visitables.get("extension").remove(this.extension);
        if (limitRangeExtension!=null){ this.extension= new LimitRangeBuilder(limitRangeExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.LimitRangeExtensionNested<A> withNewLimitRangeExtension() {
        return new LimitRangeExtensionNestedImpl();
    }

    public NamedExtensionFluent.LimitRangeExtensionNested<A> withNewLimitRangeExtensionLike(LimitRange item) {
        return new LimitRangeExtensionNestedImpl(item);
    }

    public A withAPIServiceExtension(APIService aPIServiceExtension) {
        _visitables.get("extension").remove(this.extension);
        if (aPIServiceExtension!=null){ this.extension= new APIServiceBuilder(aPIServiceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.APIServiceExtensionNested<A> withNewAPIServiceExtension() {
        return new APIServiceExtensionNestedImpl();
    }

    public NamedExtensionFluent.APIServiceExtensionNested<A> withNewAPIServiceExtensionLike(APIService item) {
        return new APIServiceExtensionNestedImpl(item);
    }

    public A withNamespaceExtension(Namespace namespaceExtension) {
        _visitables.get("extension").remove(this.extension);
        if (namespaceExtension!=null){ this.extension= new NamespaceBuilder(namespaceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.NamespaceExtensionNested<A> withNewNamespaceExtension() {
        return new NamespaceExtensionNestedImpl();
    }

    public NamedExtensionFluent.NamespaceExtensionNested<A> withNewNamespaceExtensionLike(Namespace item) {
        return new NamespaceExtensionNestedImpl(item);
    }

    public A withServiceExtension(Service serviceExtension) {
        _visitables.get("extension").remove(this.extension);
        if (serviceExtension!=null){ this.extension= new ServiceBuilder(serviceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.ServiceExtensionNested<A> withNewServiceExtension() {
        return new ServiceExtensionNestedImpl();
    }

    public NamedExtensionFluent.ServiceExtensionNested<A> withNewServiceExtensionLike(Service item) {
        return new ServiceExtensionNestedImpl(item);
    }

    public A withReplicationControllerExtension(ReplicationController replicationControllerExtension) {
        _visitables.get("extension").remove(this.extension);
        if (replicationControllerExtension!=null){ this.extension= new ReplicationControllerBuilder(replicationControllerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.ReplicationControllerExtensionNested<A> withNewReplicationControllerExtension() {
        return new ReplicationControllerExtensionNestedImpl();
    }

    public NamedExtensionFluent.ReplicationControllerExtensionNested<A> withNewReplicationControllerExtensionLike(ReplicationController item) {
        return new ReplicationControllerExtensionNestedImpl(item);
    }

    public A withPodTemplateExtension(PodTemplate podTemplateExtension) {
        _visitables.get("extension").remove(this.extension);
        if (podTemplateExtension!=null){ this.extension= new PodTemplateBuilder(podTemplateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.PodTemplateExtensionNested<A> withNewPodTemplateExtension() {
        return new PodTemplateExtensionNestedImpl();
    }

    public NamedExtensionFluent.PodTemplateExtensionNested<A> withNewPodTemplateExtensionLike(PodTemplate item) {
        return new PodTemplateExtensionNestedImpl(item);
    }

    public A withEventExtension(Event eventExtension) {
        _visitables.get("extension").remove(this.extension);
        if (eventExtension!=null){ this.extension= new EventBuilder(eventExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.EventExtensionNested<A> withNewEventExtension() {
        return new EventExtensionNestedImpl();
    }

    public NamedExtensionFluent.EventExtensionNested<A> withNewEventExtensionLike(Event item) {
        return new EventExtensionNestedImpl(item);
    }

    public A withPersistentVolumeExtension(PersistentVolume persistentVolumeExtension) {
        _visitables.get("extension").remove(this.extension);
        if (persistentVolumeExtension!=null){ this.extension= new PersistentVolumeBuilder(persistentVolumeExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtension() {
        return new PersistentVolumeExtensionNestedImpl();
    }

    public NamedExtensionFluent.PersistentVolumeExtensionNested<A> withNewPersistentVolumeExtensionLike(PersistentVolume item) {
        return new PersistentVolumeExtensionNestedImpl(item);
    }

    public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension) {
        _visitables.get("extension").remove(this.extension);
        if (persistentVolumeClaimExtension!=null){ this.extension= new PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
        return new PersistentVolumeClaimExtensionNestedImpl();
    }

    public NamedExtensionFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimExtensionNestedImpl(item);
    }

    public A withEndpointsExtension(Endpoints endpointsExtension) {
        _visitables.get("extension").remove(this.extension);
        if (endpointsExtension!=null){ this.extension= new EndpointsBuilder(endpointsExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.EndpointsExtensionNested<A> withNewEndpointsExtension() {
        return new EndpointsExtensionNestedImpl();
    }

    public NamedExtensionFluent.EndpointsExtensionNested<A> withNewEndpointsExtensionLike(Endpoints item) {
        return new EndpointsExtensionNestedImpl(item);
    }

    public A withPodExtension(Pod podExtension) {
        _visitables.get("extension").remove(this.extension);
        if (podExtension!=null){ this.extension= new PodBuilder(podExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.PodExtensionNested<A> withNewPodExtension() {
        return new PodExtensionNestedImpl();
    }

    public NamedExtensionFluent.PodExtensionNested<A> withNewPodExtensionLike(Pod item) {
        return new PodExtensionNestedImpl(item);
    }

    public A withConfigMapExtension(ConfigMap configMapExtension) {
        _visitables.get("extension").remove(this.extension);
        if (configMapExtension!=null){ this.extension= new ConfigMapBuilder(configMapExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.ConfigMapExtensionNested<A> withNewConfigMapExtension() {
        return new ConfigMapExtensionNestedImpl();
    }

    public NamedExtensionFluent.ConfigMapExtensionNested<A> withNewConfigMapExtensionLike(ConfigMap item) {
        return new ConfigMapExtensionNestedImpl(item);
    }

    public A withComponentStatusExtension(ComponentStatus componentStatusExtension) {
        _visitables.get("extension").remove(this.extension);
        if (componentStatusExtension!=null){ this.extension= new ComponentStatusBuilder(componentStatusExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.ComponentStatusExtensionNested<A> withNewComponentStatusExtension() {
        return new ComponentStatusExtensionNestedImpl();
    }

    public NamedExtensionFluent.ComponentStatusExtensionNested<A> withNewComponentStatusExtensionLike(ComponentStatus item) {
        return new ComponentStatusExtensionNestedImpl(item);
    }

    public A withBindingExtension(Binding bindingExtension) {
        _visitables.get("extension").remove(this.extension);
        if (bindingExtension!=null){ this.extension= new BindingBuilder(bindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.BindingExtensionNested<A> withNewBindingExtension() {
        return new BindingExtensionNestedImpl();
    }

    public NamedExtensionFluent.BindingExtensionNested<A> withNewBindingExtensionLike(Binding item) {
        return new BindingExtensionNestedImpl(item);
    }

    public A withResourceQuotaExtension(ResourceQuota resourceQuotaExtension) {
        _visitables.get("extension").remove(this.extension);
        if (resourceQuotaExtension!=null){ this.extension= new ResourceQuotaBuilder(resourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.ResourceQuotaExtensionNested<A> withNewResourceQuotaExtension() {
        return new ResourceQuotaExtensionNestedImpl();
    }

    public NamedExtensionFluent.ResourceQuotaExtensionNested<A> withNewResourceQuotaExtensionLike(ResourceQuota item) {
        return new ResourceQuotaExtensionNestedImpl(item);
    }

    public A withSecretExtension(Secret secretExtension) {
        _visitables.get("extension").remove(this.extension);
        if (secretExtension!=null){ this.extension= new SecretBuilder(secretExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.SecretExtensionNested<A> withNewSecretExtension() {
        return new SecretExtensionNestedImpl();
    }

    public NamedExtensionFluent.SecretExtensionNested<A> withNewSecretExtensionLike(Secret item) {
        return new SecretExtensionNestedImpl(item);
    }

    public A withNodeExtension(Node nodeExtension) {
        _visitables.get("extension").remove(this.extension);
        if (nodeExtension!=null){ this.extension= new NodeBuilder(nodeExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.NodeExtensionNested<A> withNewNodeExtension() {
        return new NodeExtensionNestedImpl();
    }

    public NamedExtensionFluent.NodeExtensionNested<A> withNewNodeExtensionLike(Node item) {
        return new NodeExtensionNestedImpl(item);
    }

    public A withServiceAccountExtension(ServiceAccount serviceAccountExtension) {
        _visitables.get("extension").remove(this.extension);
        if (serviceAccountExtension!=null){ this.extension= new ServiceAccountBuilder(serviceAccountExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public NamedExtensionFluent.ServiceAccountExtensionNested<A> withNewServiceAccountExtension() {
        return new ServiceAccountExtensionNestedImpl();
    }

    public NamedExtensionFluent.ServiceAccountExtensionNested<A> withNewServiceAccountExtensionLike(ServiceAccount item) {
        return new ServiceAccountExtensionNestedImpl(item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NamedExtensionFluentImpl that = (NamedExtensionFluentImpl) o;
        if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(extension,  name,  super.hashCode());
    }

    public class LimitRangeExtensionNestedImpl<N> extends LimitRangeFluentImpl<NamedExtensionFluent.LimitRangeExtensionNested<N>> implements NamedExtensionFluent.LimitRangeExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeBuilder builder;

            LimitRangeExtensionNestedImpl(LimitRange item) {
                this.builder = new LimitRangeBuilder(this, item);
                        
            }

            LimitRangeExtensionNestedImpl() {
                this.builder = new LimitRangeBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endLimitRangeExtension() {
                return and();
            }
    }


    public class APIServiceExtensionNestedImpl<N> extends APIServiceFluentImpl<NamedExtensionFluent.APIServiceExtensionNested<N>> implements NamedExtensionFluent.APIServiceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceBuilder builder;

            APIServiceExtensionNestedImpl(APIService item) {
                this.builder = new APIServiceBuilder(this, item);
                        
            }

            APIServiceExtensionNestedImpl() {
                this.builder = new APIServiceBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endAPIServiceExtension() {
                return and();
            }
    }


    public class NamespaceExtensionNestedImpl<N> extends NamespaceFluentImpl<NamedExtensionFluent.NamespaceExtensionNested<N>> implements NamedExtensionFluent.NamespaceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceBuilder builder;

            NamespaceExtensionNestedImpl(Namespace item) {
                this.builder = new NamespaceBuilder(this, item);
                        
            }

            NamespaceExtensionNestedImpl() {
                this.builder = new NamespaceBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endNamespaceExtension() {
                return and();
            }
    }


    public class ServiceExtensionNestedImpl<N> extends ServiceFluentImpl<NamedExtensionFluent.ServiceExtensionNested<N>> implements NamedExtensionFluent.ServiceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceBuilder builder;

            ServiceExtensionNestedImpl(Service item) {
                this.builder = new ServiceBuilder(this, item);
                        
            }

            ServiceExtensionNestedImpl() {
                this.builder = new ServiceBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endServiceExtension() {
                return and();
            }
    }


    public class ReplicationControllerExtensionNestedImpl<N> extends ReplicationControllerFluentImpl<NamedExtensionFluent.ReplicationControllerExtensionNested<N>> implements NamedExtensionFluent.ReplicationControllerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerBuilder builder;

            ReplicationControllerExtensionNestedImpl(ReplicationController item) {
                this.builder = new ReplicationControllerBuilder(this, item);
                        
            }

            ReplicationControllerExtensionNestedImpl() {
                this.builder = new ReplicationControllerBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endReplicationControllerExtension() {
                return and();
            }
    }


    public class PodTemplateExtensionNestedImpl<N> extends PodTemplateFluentImpl<NamedExtensionFluent.PodTemplateExtensionNested<N>> implements NamedExtensionFluent.PodTemplateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

            PodTemplateExtensionNestedImpl(PodTemplate item) {
                this.builder = new PodTemplateBuilder(this, item);
                        
            }

            PodTemplateExtensionNestedImpl() {
                this.builder = new PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endPodTemplateExtension() {
                return and();
            }
    }


    public class EventExtensionNestedImpl<N> extends EventFluentImpl<NamedExtensionFluent.EventExtensionNested<N>> implements NamedExtensionFluent.EventExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventBuilder builder;

            EventExtensionNestedImpl(Event item) {
                this.builder = new EventBuilder(this, item);
                        
            }

            EventExtensionNestedImpl() {
                this.builder = new EventBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endEventExtension() {
                return and();
            }
    }


    public class PersistentVolumeExtensionNestedImpl<N> extends PersistentVolumeFluentImpl<NamedExtensionFluent.PersistentVolumeExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeBuilder builder;

            PersistentVolumeExtensionNestedImpl(PersistentVolume item) {
                this.builder = new PersistentVolumeBuilder(this, item);
                        
            }

            PersistentVolumeExtensionNestedImpl() {
                this.builder = new PersistentVolumeBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endPersistentVolumeExtension() {
                return and();
            }
    }


    public class PersistentVolumeClaimExtensionNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NamedExtensionFluent.PersistentVolumeClaimExtensionNested<N>> implements NamedExtensionFluent.PersistentVolumeClaimExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimExtensionNestedImpl(PersistentVolumeClaim item) {
                this.builder = new PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimExtensionNestedImpl() {
                this.builder = new PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endPersistentVolumeClaimExtension() {
                return and();
            }
    }


    public class EndpointsExtensionNestedImpl<N> extends EndpointsFluentImpl<NamedExtensionFluent.EndpointsExtensionNested<N>> implements NamedExtensionFluent.EndpointsExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointsBuilder builder;

            EndpointsExtensionNestedImpl(Endpoints item) {
                this.builder = new EndpointsBuilder(this, item);
                        
            }

            EndpointsExtensionNestedImpl() {
                this.builder = new EndpointsBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endEndpointsExtension() {
                return and();
            }
    }


    public class PodExtensionNestedImpl<N> extends PodFluentImpl<NamedExtensionFluent.PodExtensionNested<N>> implements NamedExtensionFluent.PodExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodBuilder builder;

            PodExtensionNestedImpl(Pod item) {
                this.builder = new PodBuilder(this, item);
                        
            }

            PodExtensionNestedImpl() {
                this.builder = new PodBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endPodExtension() {
                return and();
            }
    }


    public class ConfigMapExtensionNestedImpl<N> extends ConfigMapFluentImpl<NamedExtensionFluent.ConfigMapExtensionNested<N>> implements NamedExtensionFluent.ConfigMapExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapBuilder builder;

            ConfigMapExtensionNestedImpl(ConfigMap item) {
                this.builder = new ConfigMapBuilder(this, item);
                        
            }

            ConfigMapExtensionNestedImpl() {
                this.builder = new ConfigMapBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endConfigMapExtension() {
                return and();
            }
    }


    public class ComponentStatusExtensionNestedImpl<N> extends ComponentStatusFluentImpl<NamedExtensionFluent.ComponentStatusExtensionNested<N>> implements NamedExtensionFluent.ComponentStatusExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentStatusBuilder builder;

            ComponentStatusExtensionNestedImpl(ComponentStatus item) {
                this.builder = new ComponentStatusBuilder(this, item);
                        
            }

            ComponentStatusExtensionNestedImpl() {
                this.builder = new ComponentStatusBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endComponentStatusExtension() {
                return and();
            }
    }


    public class BindingExtensionNestedImpl<N> extends BindingFluentImpl<NamedExtensionFluent.BindingExtensionNested<N>> implements NamedExtensionFluent.BindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BindingBuilder builder;

            BindingExtensionNestedImpl(Binding item) {
                this.builder = new BindingBuilder(this, item);
                        
            }

            BindingExtensionNestedImpl() {
                this.builder = new BindingBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endBindingExtension() {
                return and();
            }
    }


    public class ResourceQuotaExtensionNestedImpl<N> extends ResourceQuotaFluentImpl<NamedExtensionFluent.ResourceQuotaExtensionNested<N>> implements NamedExtensionFluent.ResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaBuilder builder;

            ResourceQuotaExtensionNestedImpl(ResourceQuota item) {
                this.builder = new ResourceQuotaBuilder(this, item);
                        
            }

            ResourceQuotaExtensionNestedImpl() {
                this.builder = new ResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endResourceQuotaExtension() {
                return and();
            }
    }


    public class SecretExtensionNestedImpl<N> extends SecretFluentImpl<NamedExtensionFluent.SecretExtensionNested<N>> implements NamedExtensionFluent.SecretExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretBuilder builder;

            SecretExtensionNestedImpl(Secret item) {
                this.builder = new SecretBuilder(this, item);
                        
            }

            SecretExtensionNestedImpl() {
                this.builder = new SecretBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endSecretExtension() {
                return and();
            }
    }


    public class NodeExtensionNestedImpl<N> extends NodeFluentImpl<NamedExtensionFluent.NodeExtensionNested<N>> implements NamedExtensionFluent.NodeExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeBuilder builder;

            NodeExtensionNestedImpl(Node item) {
                this.builder = new NodeBuilder(this, item);
                        
            }

            NodeExtensionNestedImpl() {
                this.builder = new NodeBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endNodeExtension() {
                return and();
            }
    }


    public class ServiceAccountExtensionNestedImpl<N> extends ServiceAccountFluentImpl<NamedExtensionFluent.ServiceAccountExtensionNested<N>> implements NamedExtensionFluent.ServiceAccountExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountBuilder builder;

            ServiceAccountExtensionNestedImpl(ServiceAccount item) {
                this.builder = new ServiceAccountBuilder(this, item);
                        
            }

            ServiceAccountExtensionNestedImpl() {
                this.builder = new ServiceAccountBuilder(this);
                        
            }

            public N and() {
                return (N) NamedExtensionFluentImpl.this.withExtension(builder.build());
            }

            public N endServiceAccountExtension() {
                return and();
            }
    }


}
