package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PortStatusBuilder extends PortStatusFluentImpl<PortStatusBuilder> implements VisitableBuilder<PortStatus,PortStatusBuilder> {

    PortStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PortStatusBuilder() {
        this(true);
    }

    public PortStatusBuilder(Boolean validationEnabled) {
        this(new PortStatus(), validationEnabled);
    }

    public PortStatusBuilder(PortStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public PortStatusBuilder(PortStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PortStatus(), validationEnabled);
    }

    public PortStatusBuilder(PortStatusFluent<?> fluent,PortStatus instance) {
        this(fluent, instance, true);
    }

    public PortStatusBuilder(PortStatusFluent<?> fluent,PortStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withError(instance.getError()); 
        fluent.withPort(instance.getPort()); 
        fluent.withProtocol(instance.getProtocol()); 
        this.validationEnabled = validationEnabled; 
    }

    public PortStatusBuilder(PortStatus instance) {
        this(instance,true);
    }

    public PortStatusBuilder(PortStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withError(instance.getError()); 
        this.withPort(instance.getPort()); 
        this.withProtocol(instance.getProtocol()); 
        this.validationEnabled = validationEnabled; 
    }

    public PortStatus build() {
        PortStatus buildable = new PortStatus(fluent.getError(),fluent.getPort(),fluent.getProtocol());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PortStatusBuilder that = (PortStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
