package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ScopedResourceSelectorRequirementFluentImpl<A extends ScopedResourceSelectorRequirementFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ScopedResourceSelectorRequirementFluent<A> {

    private String operator;
    private String scopeName;
    private List<String> values = new ArrayList<String>();

    public ScopedResourceSelectorRequirementFluentImpl() {
    }

    public ScopedResourceSelectorRequirementFluentImpl(ScopedResourceSelectorRequirement instance) {
        this.withOperator(instance.getOperator()); 
        this.withScopeName(instance.getScopeName()); 
        this.withValues(instance.getValues()); 
    }

    public String getOperator() {
        return this.operator;
    }

    public A withOperator(String operator) {
        this.operator=operator; return (A) this;
    }

    public Boolean hasOperator() {
        return this.operator != null;
    }

    public A withNewOperator(StringBuilder arg1) {
        return (A)withOperator(new String(arg1));
    }

    public A withNewOperator(int[] arg1,int arg2,int arg3) {
        return (A)withOperator(new String(arg1, arg2, arg3));
    }

    public A withNewOperator(char[] arg1) {
        return (A)withOperator(new String(arg1));
    }

    public A withNewOperator(StringBuffer arg1) {
        return (A)withOperator(new String(arg1));
    }

    public A withNewOperator(byte[] arg1,int arg2) {
        return (A)withOperator(new String(arg1, arg2));
    }

    public A withNewOperator(byte[] arg1) {
        return (A)withOperator(new String(arg1));
    }

    public A withNewOperator(char[] arg1,int arg2,int arg3) {
        return (A)withOperator(new String(arg1, arg2, arg3));
    }

    public A withNewOperator(byte[] arg1,int arg2,int arg3) {
        return (A)withOperator(new String(arg1, arg2, arg3));
    }

    public A withNewOperator(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOperator(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOperator(String arg1) {
        return (A)withOperator(new String(arg1));
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public A withScopeName(String scopeName) {
        this.scopeName=scopeName; return (A) this;
    }

    public Boolean hasScopeName() {
        return this.scopeName != null;
    }

    public A withNewScopeName(StringBuilder arg1) {
        return (A)withScopeName(new String(arg1));
    }

    public A withNewScopeName(int[] arg1,int arg2,int arg3) {
        return (A)withScopeName(new String(arg1, arg2, arg3));
    }

    public A withNewScopeName(char[] arg1) {
        return (A)withScopeName(new String(arg1));
    }

    public A withNewScopeName(StringBuffer arg1) {
        return (A)withScopeName(new String(arg1));
    }

    public A withNewScopeName(byte[] arg1,int arg2) {
        return (A)withScopeName(new String(arg1, arg2));
    }

    public A withNewScopeName(byte[] arg1) {
        return (A)withScopeName(new String(arg1));
    }

    public A withNewScopeName(char[] arg1,int arg2,int arg3) {
        return (A)withScopeName(new String(arg1, arg2, arg3));
    }

    public A withNewScopeName(byte[] arg1,int arg2,int arg3) {
        return (A)withScopeName(new String(arg1, arg2, arg3));
    }

    public A withNewScopeName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withScopeName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewScopeName(String arg1) {
        return (A)withScopeName(new String(arg1));
    }

    public A addToValues(int index,String item) {
        if (this.values == null) {this.values = new ArrayList<String>();}
        this.values.add(index, item);
        return (A)this;
    }

    public A setToValues(int index,String item) {
        if (this.values == null) {this.values = new ArrayList<String>();}
        this.values.set(index, item); return (A)this;
    }

    public A addToValues(String... items) {
        if (this.values == null) {this.values = new ArrayList<String>();}
        for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {this.values = new ArrayList<String>();}
        for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A removeFromValues(String... items) {
        for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
    }

    public A removeAllFromValues(Collection<String> items) {
        for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public String getFirstValue() {
        return this.values.get(0);
    }

    public String getLastValue() {
        return this.values.get(values.size() - 1);
    }

    public String getMatchingValue(Predicate<String> predicate) {
        for (String item: values) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item: values) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withValues(List<String> values) {
        if (this.values != null) { _visitables.get("values").removeAll(this.values);}
        if (values != null) {this.values = new ArrayList<String>(); for (String item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
    }

    public A withValues(String... values) {
        if (this.values != null) {this.values.clear();}
        if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
    }

    public Boolean hasValues() {
        return values != null && !values.isEmpty();
    }

    public A addNewValue(StringBuilder arg1) {
        return (A)addToValues(new String(arg1));
    }

    public A addNewValue(int[] arg1,int arg2,int arg3) {
        return (A)addToValues(new String(arg1, arg2, arg3));
    }

    public A addNewValue(char[] arg1) {
        return (A)addToValues(new String(arg1));
    }

    public A addNewValue(StringBuffer arg1) {
        return (A)addToValues(new String(arg1));
    }

    public A addNewValue(byte[] arg1,int arg2) {
        return (A)addToValues(new String(arg1, arg2));
    }

    public A addNewValue(byte[] arg1) {
        return (A)addToValues(new String(arg1));
    }

    public A addNewValue(char[] arg1,int arg2,int arg3) {
        return (A)addToValues(new String(arg1, arg2, arg3));
    }

    public A addNewValue(byte[] arg1,int arg2,int arg3) {
        return (A)addToValues(new String(arg1, arg2, arg3));
    }

    public A addNewValue(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToValues(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewValue(String arg1) {
        return (A)addToValues(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ScopedResourceSelectorRequirementFluentImpl that = (ScopedResourceSelectorRequirementFluentImpl) o;
        if (operator != null ? !operator.equals(that.operator) :that.operator != null) return false;
        if (scopeName != null ? !scopeName.equals(that.scopeName) :that.scopeName != null) return false;
        if (values != null ? !values.equals(that.values) :that.values != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(operator,  scopeName,  values,  super.hashCode());
    }

}
