package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceSpecFluent<A> {

    private Boolean allocateLoadBalancerNodePorts;
    private String clusterIP;
    private List<String> clusterIPs = new ArrayList<String>();
    private List<String> externalIPs = new ArrayList<String>();
    private String externalName;
    private String externalTrafficPolicy;
    private Integer healthCheckNodePort;
    private List<String> ipFamilies = new ArrayList<String>();
    private String ipFamilyPolicy;
    private String loadBalancerIP;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    private List<ServicePortBuilder> ports =  new ArrayList<ServicePortBuilder>();
    private Boolean publishNotReadyAddresses;
    private Map<String,String> selector;
    private String sessionAffinity;
    private SessionAffinityConfigBuilder sessionAffinityConfig;
    private List<String> topologyKeys = new ArrayList<String>();
    private String type;

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts()); 
        this.withClusterIP(instance.getClusterIP()); 
        this.withClusterIPs(instance.getClusterIPs()); 
        this.withExternalIPs(instance.getExternalIPs()); 
        this.withExternalName(instance.getExternalName()); 
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy()); 
        this.withHealthCheckNodePort(instance.getHealthCheckNodePort()); 
        this.withIpFamilies(instance.getIpFamilies()); 
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy()); 
        this.withLoadBalancerIP(instance.getLoadBalancerIP()); 
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges()); 
        this.withPorts(instance.getPorts()); 
        this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses()); 
        this.withSelector(instance.getSelector()); 
        this.withSessionAffinity(instance.getSessionAffinity()); 
        this.withSessionAffinityConfig(instance.getSessionAffinityConfig()); 
        this.withTopologyKeys(instance.getTopologyKeys()); 
        this.withType(instance.getType()); 
    }

    public Boolean getAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts;
    }

    public A withAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
        this.allocateLoadBalancerNodePorts=allocateLoadBalancerNodePorts; return (A) this;
    }

    public Boolean hasAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts != null;
    }

    public A withNewAllocateLoadBalancerNodePorts(String arg1) {
        return (A)withAllocateLoadBalancerNodePorts(new Boolean(arg1));
    }

    public A withNewAllocateLoadBalancerNodePorts(boolean arg1) {
        return (A)withAllocateLoadBalancerNodePorts(new Boolean(arg1));
    }

    public String getClusterIP() {
        return this.clusterIP;
    }

    public A withClusterIP(String clusterIP) {
        this.clusterIP=clusterIP; return (A) this;
    }

    public Boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    public A withNewClusterIP(StringBuilder arg1) {
        return (A)withClusterIP(new String(arg1));
    }

    public A withNewClusterIP(int[] arg1,int arg2,int arg3) {
        return (A)withClusterIP(new String(arg1, arg2, arg3));
    }

    public A withNewClusterIP(char[] arg1) {
        return (A)withClusterIP(new String(arg1));
    }

    public A withNewClusterIP(StringBuffer arg1) {
        return (A)withClusterIP(new String(arg1));
    }

    public A withNewClusterIP(byte[] arg1,int arg2) {
        return (A)withClusterIP(new String(arg1, arg2));
    }

    public A withNewClusterIP(byte[] arg1) {
        return (A)withClusterIP(new String(arg1));
    }

    public A withNewClusterIP(char[] arg1,int arg2,int arg3) {
        return (A)withClusterIP(new String(arg1, arg2, arg3));
    }

    public A withNewClusterIP(byte[] arg1,int arg2,int arg3) {
        return (A)withClusterIP(new String(arg1, arg2, arg3));
    }

    public A withNewClusterIP(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withClusterIP(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewClusterIP(String arg1) {
        return (A)withClusterIP(new String(arg1));
    }

    public A addToClusterIPs(int index,String item) {
        if (this.clusterIPs == null) {this.clusterIPs = new ArrayList<String>();}
        this.clusterIPs.add(index, item);
        return (A)this;
    }

    public A setToClusterIPs(int index,String item) {
        if (this.clusterIPs == null) {this.clusterIPs = new ArrayList<String>();}
        this.clusterIPs.set(index, item); return (A)this;
    }

    public A addToClusterIPs(String... items) {
        if (this.clusterIPs == null) {this.clusterIPs = new ArrayList<String>();}
        for (String item : items) {this.clusterIPs.add(item);} return (A)this;
    }

    public A addAllToClusterIPs(Collection<String> items) {
        if (this.clusterIPs == null) {this.clusterIPs = new ArrayList<String>();}
        for (String item : items) {this.clusterIPs.add(item);} return (A)this;
    }

    public A removeFromClusterIPs(String... items) {
        for (String item : items) {if (this.clusterIPs!= null){ this.clusterIPs.remove(item);}} return (A)this;
    }

    public A removeAllFromClusterIPs(Collection<String> items) {
        for (String item : items) {if (this.clusterIPs!= null){ this.clusterIPs.remove(item);}} return (A)this;
    }

    public List<String> getClusterIPs() {
        return this.clusterIPs;
    }

    public String getClusterIP(int index) {
        return this.clusterIPs.get(index);
    }

    public String getFirstClusterIP() {
        return this.clusterIPs.get(0);
    }

    public String getLastClusterIP() {
        return this.clusterIPs.get(clusterIPs.size() - 1);
    }

    public String getMatchingClusterIP(Predicate<String> predicate) {
        for (String item: clusterIPs) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingClusterIP(Predicate<String> predicate) {
        for (String item: clusterIPs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusterIPs(List<String> clusterIPs) {
        if (this.clusterIPs != null) { _visitables.get("clusterIPs").removeAll(this.clusterIPs);}
        if (clusterIPs != null) {this.clusterIPs = new ArrayList<String>(); for (String item : clusterIPs){this.addToClusterIPs(item);}} else { this.clusterIPs = null;} return (A) this;
    }

    public A withClusterIPs(String... clusterIPs) {
        if (this.clusterIPs != null) {this.clusterIPs.clear();}
        if (clusterIPs != null) {for (String item :clusterIPs){ this.addToClusterIPs(item);}} return (A) this;
    }

    public Boolean hasClusterIPs() {
        return clusterIPs != null && !clusterIPs.isEmpty();
    }

    public A addNewClusterIP(StringBuilder arg1) {
        return (A)addToClusterIPs(new String(arg1));
    }

    public A addNewClusterIP(int[] arg1,int arg2,int arg3) {
        return (A)addToClusterIPs(new String(arg1, arg2, arg3));
    }

    public A addNewClusterIP(char[] arg1) {
        return (A)addToClusterIPs(new String(arg1));
    }

    public A addNewClusterIP(StringBuffer arg1) {
        return (A)addToClusterIPs(new String(arg1));
    }

    public A addNewClusterIP(byte[] arg1,int arg2) {
        return (A)addToClusterIPs(new String(arg1, arg2));
    }

    public A addNewClusterIP(byte[] arg1) {
        return (A)addToClusterIPs(new String(arg1));
    }

    public A addNewClusterIP(char[] arg1,int arg2,int arg3) {
        return (A)addToClusterIPs(new String(arg1, arg2, arg3));
    }

    public A addNewClusterIP(byte[] arg1,int arg2,int arg3) {
        return (A)addToClusterIPs(new String(arg1, arg2, arg3));
    }

    public A addNewClusterIP(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToClusterIPs(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewClusterIP(String arg1) {
        return (A)addToClusterIPs(new String(arg1));
    }

    public A addToExternalIPs(int index,String item) {
        if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
        this.externalIPs.add(index, item);
        return (A)this;
    }

    public A setToExternalIPs(int index,String item) {
        if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
        this.externalIPs.set(index, item); return (A)this;
    }

    public A addToExternalIPs(String... items) {
        if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
        for (String item : items) {this.externalIPs.add(item);} return (A)this;
    }

    public A addAllToExternalIPs(Collection<String> items) {
        if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
        for (String item : items) {this.externalIPs.add(item);} return (A)this;
    }

    public A removeFromExternalIPs(String... items) {
        for (String item : items) {if (this.externalIPs!= null){ this.externalIPs.remove(item);}} return (A)this;
    }

    public A removeAllFromExternalIPs(Collection<String> items) {
        for (String item : items) {if (this.externalIPs!= null){ this.externalIPs.remove(item);}} return (A)this;
    }

    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    public String getExternalIP(int index) {
        return this.externalIPs.get(index);
    }

    public String getFirstExternalIP() {
        return this.externalIPs.get(0);
    }

    public String getLastExternalIP() {
        return this.externalIPs.get(externalIPs.size() - 1);
    }

    public String getMatchingExternalIP(Predicate<String> predicate) {
        for (String item: externalIPs) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExternalIP(Predicate<String> predicate) {
        for (String item: externalIPs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExternalIPs(List<String> externalIPs) {
        if (this.externalIPs != null) { _visitables.get("externalIPs").removeAll(this.externalIPs);}
        if (externalIPs != null) {this.externalIPs = new ArrayList<String>(); for (String item : externalIPs){this.addToExternalIPs(item);}} else { this.externalIPs = null;} return (A) this;
    }

    public A withExternalIPs(String... externalIPs) {
        if (this.externalIPs != null) {this.externalIPs.clear();}
        if (externalIPs != null) {for (String item :externalIPs){ this.addToExternalIPs(item);}} return (A) this;
    }

    public Boolean hasExternalIPs() {
        return externalIPs != null && !externalIPs.isEmpty();
    }

    public A addNewExternalIP(StringBuilder arg1) {
        return (A)addToExternalIPs(new String(arg1));
    }

    public A addNewExternalIP(int[] arg1,int arg2,int arg3) {
        return (A)addToExternalIPs(new String(arg1, arg2, arg3));
    }

    public A addNewExternalIP(char[] arg1) {
        return (A)addToExternalIPs(new String(arg1));
    }

    public A addNewExternalIP(StringBuffer arg1) {
        return (A)addToExternalIPs(new String(arg1));
    }

    public A addNewExternalIP(byte[] arg1,int arg2) {
        return (A)addToExternalIPs(new String(arg1, arg2));
    }

    public A addNewExternalIP(byte[] arg1) {
        return (A)addToExternalIPs(new String(arg1));
    }

    public A addNewExternalIP(char[] arg1,int arg2,int arg3) {
        return (A)addToExternalIPs(new String(arg1, arg2, arg3));
    }

    public A addNewExternalIP(byte[] arg1,int arg2,int arg3) {
        return (A)addToExternalIPs(new String(arg1, arg2, arg3));
    }

    public A addNewExternalIP(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToExternalIPs(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewExternalIP(String arg1) {
        return (A)addToExternalIPs(new String(arg1));
    }

    public String getExternalName() {
        return this.externalName;
    }

    public A withExternalName(String externalName) {
        this.externalName=externalName; return (A) this;
    }

    public Boolean hasExternalName() {
        return this.externalName != null;
    }

    public A withNewExternalName(StringBuilder arg1) {
        return (A)withExternalName(new String(arg1));
    }

    public A withNewExternalName(int[] arg1,int arg2,int arg3) {
        return (A)withExternalName(new String(arg1, arg2, arg3));
    }

    public A withNewExternalName(char[] arg1) {
        return (A)withExternalName(new String(arg1));
    }

    public A withNewExternalName(StringBuffer arg1) {
        return (A)withExternalName(new String(arg1));
    }

    public A withNewExternalName(byte[] arg1,int arg2) {
        return (A)withExternalName(new String(arg1, arg2));
    }

    public A withNewExternalName(byte[] arg1) {
        return (A)withExternalName(new String(arg1));
    }

    public A withNewExternalName(char[] arg1,int arg2,int arg3) {
        return (A)withExternalName(new String(arg1, arg2, arg3));
    }

    public A withNewExternalName(byte[] arg1,int arg2,int arg3) {
        return (A)withExternalName(new String(arg1, arg2, arg3));
    }

    public A withNewExternalName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withExternalName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewExternalName(String arg1) {
        return (A)withExternalName(new String(arg1));
    }

    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public A withExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy=externalTrafficPolicy; return (A) this;
    }

    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    public A withNewExternalTrafficPolicy(StringBuilder arg1) {
        return (A)withExternalTrafficPolicy(new String(arg1));
    }

    public A withNewExternalTrafficPolicy(int[] arg1,int arg2,int arg3) {
        return (A)withExternalTrafficPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewExternalTrafficPolicy(char[] arg1) {
        return (A)withExternalTrafficPolicy(new String(arg1));
    }

    public A withNewExternalTrafficPolicy(StringBuffer arg1) {
        return (A)withExternalTrafficPolicy(new String(arg1));
    }

    public A withNewExternalTrafficPolicy(byte[] arg1,int arg2) {
        return (A)withExternalTrafficPolicy(new String(arg1, arg2));
    }

    public A withNewExternalTrafficPolicy(byte[] arg1) {
        return (A)withExternalTrafficPolicy(new String(arg1));
    }

    public A withNewExternalTrafficPolicy(char[] arg1,int arg2,int arg3) {
        return (A)withExternalTrafficPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewExternalTrafficPolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withExternalTrafficPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewExternalTrafficPolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withExternalTrafficPolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewExternalTrafficPolicy(String arg1) {
        return (A)withExternalTrafficPolicy(new String(arg1));
    }

    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    public A withHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort=healthCheckNodePort; return (A) this;
    }

    public Boolean hasHealthCheckNodePort() {
        return this.healthCheckNodePort != null;
    }

    public A withNewHealthCheckNodePort(int arg1) {
        return (A)withHealthCheckNodePort(new Integer(arg1));
    }

    public A addToIpFamilies(int index,String item) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<String>();}
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    public A setToIpFamilies(int index,String item) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<String>();}
        this.ipFamilies.set(index, item); return (A)this;
    }

    public A addToIpFamilies(String... items) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<String>();}
        for (String item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A addAllToIpFamilies(Collection<String> items) {
        if (this.ipFamilies == null) {this.ipFamilies = new ArrayList<String>();}
        for (String item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A removeFromIpFamilies(String... items) {
        for (String item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public A removeAllFromIpFamilies(Collection<String> items) {
        for (String item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public List<String> getIpFamilies() {
        return this.ipFamilies;
    }

    public String getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public String getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public String getLastIpFamily() {
        return this.ipFamilies.get(ipFamilies.size() - 1);
    }

    public String getMatchingIpFamily(Predicate<String> predicate) {
        for (String item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingIpFamily(Predicate<String> predicate) {
        for (String item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpFamilies(List<String> ipFamilies) {
        if (this.ipFamilies != null) { _visitables.get("ipFamilies").removeAll(this.ipFamilies);}
        if (ipFamilies != null) {this.ipFamilies = new ArrayList<String>(); for (String item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
    }

    public A withIpFamilies(String... ipFamilies) {
        if (this.ipFamilies != null) {this.ipFamilies.clear();}
        if (ipFamilies != null) {for (String item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
    }

    public Boolean hasIpFamilies() {
        return ipFamilies != null && !ipFamilies.isEmpty();
    }

    public A addNewIpFamily(StringBuilder arg1) {
        return (A)addToIpFamilies(new String(arg1));
    }

    public A addNewIpFamily(int[] arg1,int arg2,int arg3) {
        return (A)addToIpFamilies(new String(arg1, arg2, arg3));
    }

    public A addNewIpFamily(char[] arg1) {
        return (A)addToIpFamilies(new String(arg1));
    }

    public A addNewIpFamily(StringBuffer arg1) {
        return (A)addToIpFamilies(new String(arg1));
    }

    public A addNewIpFamily(byte[] arg1,int arg2) {
        return (A)addToIpFamilies(new String(arg1, arg2));
    }

    public A addNewIpFamily(byte[] arg1) {
        return (A)addToIpFamilies(new String(arg1));
    }

    public A addNewIpFamily(char[] arg1,int arg2,int arg3) {
        return (A)addToIpFamilies(new String(arg1, arg2, arg3));
    }

    public A addNewIpFamily(byte[] arg1,int arg2,int arg3) {
        return (A)addToIpFamilies(new String(arg1, arg2, arg3));
    }

    public A addNewIpFamily(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToIpFamilies(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewIpFamily(String arg1) {
        return (A)addToIpFamilies(new String(arg1));
    }

    public String getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(String ipFamilyPolicy) {
        this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
    }

    public Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A withNewIpFamilyPolicy(StringBuilder arg1) {
        return (A)withIpFamilyPolicy(new String(arg1));
    }

    public A withNewIpFamilyPolicy(int[] arg1,int arg2,int arg3) {
        return (A)withIpFamilyPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewIpFamilyPolicy(char[] arg1) {
        return (A)withIpFamilyPolicy(new String(arg1));
    }

    public A withNewIpFamilyPolicy(StringBuffer arg1) {
        return (A)withIpFamilyPolicy(new String(arg1));
    }

    public A withNewIpFamilyPolicy(byte[] arg1,int arg2) {
        return (A)withIpFamilyPolicy(new String(arg1, arg2));
    }

    public A withNewIpFamilyPolicy(byte[] arg1) {
        return (A)withIpFamilyPolicy(new String(arg1));
    }

    public A withNewIpFamilyPolicy(char[] arg1,int arg2,int arg3) {
        return (A)withIpFamilyPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewIpFamilyPolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withIpFamilyPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewIpFamilyPolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withIpFamilyPolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewIpFamilyPolicy(String arg1) {
        return (A)withIpFamilyPolicy(new String(arg1));
    }

    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP=loadBalancerIP; return (A) this;
    }

    public Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    public A withNewLoadBalancerIP(StringBuilder arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(int[] arg1,int arg2,int arg3) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3));
    }

    public A withNewLoadBalancerIP(char[] arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(StringBuffer arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(byte[] arg1,int arg2) {
        return (A)withLoadBalancerIP(new String(arg1, arg2));
    }

    public A withNewLoadBalancerIP(byte[] arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(char[] arg1,int arg2,int arg3) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3));
    }

    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3));
    }

    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLoadBalancerIP(String arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A addToLoadBalancerSourceRanges(int index,String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    public A setToLoadBalancerSourceRanges(int index,String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        this.loadBalancerSourceRanges.set(index, item); return (A)this;
    }

    public A addToLoadBalancerSourceRanges(String... items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new ArrayList<String>();}
        for (String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A removeFromLoadBalancerSourceRanges(String... items) {
        for (String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(loadBalancerSourceRanges.size() - 1);
    }

    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) { _visitables.get("loadBalancerSourceRanges").removeAll(this.loadBalancerSourceRanges);}
        if (loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges = new ArrayList<String>(); for (String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} else { this.loadBalancerSourceRanges = null;} return (A) this;
    }

    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges.clear();}
        if (loadBalancerSourceRanges != null) {for (String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
    }

    public Boolean hasLoadBalancerSourceRanges() {
        return loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty();
    }

    public A addNewLoadBalancerSourceRange(StringBuilder arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(int[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(char[] arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(StringBuffer arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addNewLoadBalancerSourceRange(char[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewLoadBalancerSourceRange(String arg1) {
        return (A)addToLoadBalancerSourceRanges(new String(arg1));
    }

    public A addToPorts(int index,ServicePort item) {
        if (this.ports == null) {this.ports = new ArrayList<ServicePortBuilder>();}
        ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,ServicePort item) {
        if (this.ports == null) {this.ports = new ArrayList<ServicePortBuilder>();}
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
        if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
         return (A)this;
    }

    public A addToPorts(ServicePort... items) {
        if (this.ports == null) {this.ports = new ArrayList<ServicePortBuilder>();}
        for (ServicePort item : items) {ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<ServicePort> items) {
        if (this.ports == null) {this.ports = new ArrayList<ServicePortBuilder>();}
        for (ServicePort item : items) {ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(ServicePort... items) {
        for (ServicePort item : items) {ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<ServicePort> items) {
        for (ServicePort item : items) {ServicePortBuilder builder = new ServicePortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate) {
        if (ports == null) return (A) this;
        final Iterator<ServicePortBuilder> each = ports.iterator();
        final List visitables = _visitables.get("ports");
        while (each.hasNext()) {
          ServicePortBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<ServicePort> getPorts() {
        return build(ports);
    }

    public List<ServicePort> buildPorts() {
        return build(ports);
    }

    public ServicePort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public ServicePort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public ServicePort buildLastPort() {
        return this.ports.get(ports.size() - 1).build();
    }

    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPorts(List<ServicePort> ports) {
        if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
        if (ports != null) {this.ports = new ArrayList<ServicePortBuilder>(); for (ServicePort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(ServicePort... ports) {
        if (this.ports != null) {this.ports.clear();}
        if (ports != null) {for (ServicePort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts() {
        return ports != null && !ports.isEmpty();
    }

    public ServiceSpecFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNestedImpl(-1, item);
    }

    public ServiceSpecFluent.PortsNested<A> setNewPortLike(int index,ServicePort item) {
        return new PortsNestedImpl(index, item);
    }

    public ServiceSpecFluent.PortsNested<A> editPort(int index) {
        if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
        return setNewPortLike(index, buildPort(index));
    }

    public ServiceSpecFluent.PortsNested<A> editFirstPort() {
        if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
        return setNewPortLike(0, buildPort(0));
    }

    public ServiceSpecFluent.PortsNested<A> editLastPort() {
        int index = ports.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
        return setNewPortLike(index, buildPort(index));
    }

    public ServiceSpecFluent.PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ports.size();i++) { 
        if (predicate.test(ports.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
        return setNewPortLike(index, buildPort(index));
    }

    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses=publishNotReadyAddresses; return (A) this;
    }

    public Boolean hasPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses != null;
    }

    public A withNewPublishNotReadyAddresses(String arg1) {
        return (A)withPublishNotReadyAddresses(new Boolean(arg1));
    }

    public A withNewPublishNotReadyAddresses(boolean arg1) {
        return (A)withPublishNotReadyAddresses(new Boolean(arg1));
    }

    public A addToSelector(String key,String value) {
        if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }

    public A addToSelector(Map<String,String> map) {
        if(this.selector == null && map != null) { this.selector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.selector.putAll(map);} return (A)this;
    }

    public A removeFromSelector(String key) {
        if(this.selector == null) { return (A) this; }
        if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
    }

    public A removeFromSelector(Map<String,String> map) {
        if(this.selector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSelector() {
        return this.selector;
    }

    public <K extends Object,V extends Object>A withSelector(Map<String,String> selector) {
        if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap<String,String>(selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public A withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity=sessionAffinity; return (A) this;
    }

    public Boolean hasSessionAffinity() {
        return this.sessionAffinity != null;
    }

    public A withNewSessionAffinity(StringBuilder arg1) {
        return (A)withSessionAffinity(new String(arg1));
    }

    public A withNewSessionAffinity(int[] arg1,int arg2,int arg3) {
        return (A)withSessionAffinity(new String(arg1, arg2, arg3));
    }

    public A withNewSessionAffinity(char[] arg1) {
        return (A)withSessionAffinity(new String(arg1));
    }

    public A withNewSessionAffinity(StringBuffer arg1) {
        return (A)withSessionAffinity(new String(arg1));
    }

    public A withNewSessionAffinity(byte[] arg1,int arg2) {
        return (A)withSessionAffinity(new String(arg1, arg2));
    }

    public A withNewSessionAffinity(byte[] arg1) {
        return (A)withSessionAffinity(new String(arg1));
    }

    public A withNewSessionAffinity(char[] arg1,int arg2,int arg3) {
        return (A)withSessionAffinity(new String(arg1, arg2, arg3));
    }

    public A withNewSessionAffinity(byte[] arg1,int arg2,int arg3) {
        return (A)withSessionAffinity(new String(arg1, arg2, arg3));
    }

    public A withNewSessionAffinity(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSessionAffinity(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSessionAffinity(String arg1) {
        return (A)withSessionAffinity(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSessionAffinityConfig instead.
 * @return The buildable object.
 */
@Deprecated public SessionAffinityConfig getSessionAffinityConfig() {
        return this.sessionAffinityConfig!=null?this.sessionAffinityConfig.build():null;
    }

    public SessionAffinityConfig buildSessionAffinityConfig() {
        return this.sessionAffinityConfig!=null?this.sessionAffinityConfig.build():null;
    }

    public A withSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig) {
        _visitables.get("sessionAffinityConfig").remove(this.sessionAffinityConfig);
        if (sessionAffinityConfig!=null){ this.sessionAffinityConfig= new SessionAffinityConfigBuilder(sessionAffinityConfig); _visitables.get("sessionAffinityConfig").add(this.sessionAffinityConfig);} return (A) this;
    }

    public Boolean hasSessionAffinityConfig() {
        return this.sessionAffinityConfig != null;
    }

    public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig() {
        return new SessionAffinityConfigNestedImpl();
    }

    public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return new SessionAffinityConfigNestedImpl(item);
    }

    public ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig() {
        return withNewSessionAffinityConfigLike(getSessionAffinityConfig());
    }

    public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig() {
        return withNewSessionAffinityConfigLike(getSessionAffinityConfig() != null ? getSessionAffinityConfig(): new SessionAffinityConfigBuilder().build());
    }

    public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return withNewSessionAffinityConfigLike(getSessionAffinityConfig() != null ? getSessionAffinityConfig(): item);
    }

    public A addToTopologyKeys(int index,String item) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    public A setToTopologyKeys(int index,String item) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        this.topologyKeys.set(index, item); return (A)this;
    }

    public A addToTopologyKeys(String... items) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A removeFromTopologyKeys(String... items) {
        for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    public String getLastTopologyKey() {
        return this.topologyKeys.get(topologyKeys.size() - 1);
    }

    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item: topologyKeys) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item: topologyKeys) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopologyKeys(List<String> topologyKeys) {
        if (this.topologyKeys != null) { _visitables.get("topologyKeys").removeAll(this.topologyKeys);}
        if (topologyKeys != null) {this.topologyKeys = new ArrayList<String>(); for (String item : topologyKeys){this.addToTopologyKeys(item);}} else { this.topologyKeys = null;} return (A) this;
    }

    public A withTopologyKeys(String... topologyKeys) {
        if (this.topologyKeys != null) {this.topologyKeys.clear();}
        if (topologyKeys != null) {for (String item :topologyKeys){ this.addToTopologyKeys(item);}} return (A) this;
    }

    public Boolean hasTopologyKeys() {
        return topologyKeys != null && !topologyKeys.isEmpty();
    }

    public A addNewTopologyKey(StringBuilder arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(int[] arg1,int arg2,int arg3) {
        return (A)addToTopologyKeys(new String(arg1, arg2, arg3));
    }

    public A addNewTopologyKey(char[] arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuffer arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(byte[] arg1,int arg2) {
        return (A)addToTopologyKeys(new String(arg1, arg2));
    }

    public A addNewTopologyKey(byte[] arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(char[] arg1,int arg2,int arg3) {
        return (A)addToTopologyKeys(new String(arg1, arg2, arg3));
    }

    public A addNewTopologyKey(byte[] arg1,int arg2,int arg3) {
        return (A)addToTopologyKeys(new String(arg1, arg2, arg3));
    }

    public A addNewTopologyKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToTopologyKeys(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewTopologyKey(String arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl) o;
        if (allocateLoadBalancerNodePorts != null ? !allocateLoadBalancerNodePorts.equals(that.allocateLoadBalancerNodePorts) :that.allocateLoadBalancerNodePorts != null) return false;
        if (clusterIP != null ? !clusterIP.equals(that.clusterIP) :that.clusterIP != null) return false;
        if (clusterIPs != null ? !clusterIPs.equals(that.clusterIPs) :that.clusterIPs != null) return false;
        if (externalIPs != null ? !externalIPs.equals(that.externalIPs) :that.externalIPs != null) return false;
        if (externalName != null ? !externalName.equals(that.externalName) :that.externalName != null) return false;
        if (externalTrafficPolicy != null ? !externalTrafficPolicy.equals(that.externalTrafficPolicy) :that.externalTrafficPolicy != null) return false;
        if (healthCheckNodePort != null ? !healthCheckNodePort.equals(that.healthCheckNodePort) :that.healthCheckNodePort != null) return false;
        if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
        if (ipFamilyPolicy != null ? !ipFamilyPolicy.equals(that.ipFamilyPolicy) :that.ipFamilyPolicy != null) return false;
        if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
        if (loadBalancerSourceRanges != null ? !loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) :that.loadBalancerSourceRanges != null) return false;
        if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
        if (publishNotReadyAddresses != null ? !publishNotReadyAddresses.equals(that.publishNotReadyAddresses) :that.publishNotReadyAddresses != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (sessionAffinity != null ? !sessionAffinity.equals(that.sessionAffinity) :that.sessionAffinity != null) return false;
        if (sessionAffinityConfig != null ? !sessionAffinityConfig.equals(that.sessionAffinityConfig) :that.sessionAffinityConfig != null) return false;
        if (topologyKeys != null ? !topologyKeys.equals(that.topologyKeys) :that.topologyKeys != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allocateLoadBalancerNodePorts,  clusterIP,  clusterIPs,  externalIPs,  externalName,  externalTrafficPolicy,  healthCheckNodePort,  ipFamilies,  ipFamilyPolicy,  loadBalancerIP,  loadBalancerSourceRanges,  ports,  publishNotReadyAddresses,  selector,  sessionAffinity,  sessionAffinityConfig,  topologyKeys,  type,  super.hashCode());
    }

    public class PortsNestedImpl<N> extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>> implements ServiceSpecFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServicePortBuilder builder;
        private final int index;

            PortsNestedImpl(int index,ServicePort item) {
                this.index = index;
                this.builder = new ServicePortBuilder(this, item);
                        
            }

            PortsNestedImpl() {
                this.index = -1;
                this.builder = new ServicePortBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceSpecFluentImpl.this.setToPorts(index,builder.build());
            }

            public N endPort() {
                return and();
            }
    }


    public class SessionAffinityConfigNestedImpl<N> extends SessionAffinityConfigFluentImpl<ServiceSpecFluent.SessionAffinityConfigNested<N>> implements ServiceSpecFluent.SessionAffinityConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SessionAffinityConfigBuilder builder;

            SessionAffinityConfigNestedImpl(SessionAffinityConfig item) {
                this.builder = new SessionAffinityConfigBuilder(this, item);
                        
            }

            SessionAffinityConfigNestedImpl() {
                this.builder = new SessionAffinityConfigBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceSpecFluentImpl.this.withSessionAffinityConfig(builder.build());
            }

            public N endSessionAffinityConfig() {
                return and();
            }
    }


}
