package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VolumeMountFluentImpl<A extends VolumeMountFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VolumeMountFluent<A> {

    private String mountPath;
    private String mountPropagation;
    private String name;
    private Boolean readOnly;
    private String subPath;
    private String subPathExpr;

    public VolumeMountFluentImpl() {
    }

    public VolumeMountFluentImpl(VolumeMount instance) {
        this.withMountPath(instance.getMountPath()); 
        this.withMountPropagation(instance.getMountPropagation()); 
        this.withName(instance.getName()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSubPath(instance.getSubPath()); 
        this.withSubPathExpr(instance.getSubPathExpr()); 
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath=mountPath; return (A) this;
    }

    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    public A withNewMountPath(StringBuilder arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(int[] arg1,int arg2,int arg3) {
        return (A)withMountPath(new String(arg1, arg2, arg3));
    }

    public A withNewMountPath(char[] arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(StringBuffer arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(byte[] arg1,int arg2) {
        return (A)withMountPath(new String(arg1, arg2));
    }

    public A withNewMountPath(byte[] arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public A withNewMountPath(char[] arg1,int arg2,int arg3) {
        return (A)withMountPath(new String(arg1, arg2, arg3));
    }

    public A withNewMountPath(byte[] arg1,int arg2,int arg3) {
        return (A)withMountPath(new String(arg1, arg2, arg3));
    }

    public A withNewMountPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMountPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMountPath(String arg1) {
        return (A)withMountPath(new String(arg1));
    }

    public String getMountPropagation() {
        return this.mountPropagation;
    }

    public A withMountPropagation(String mountPropagation) {
        this.mountPropagation=mountPropagation; return (A) this;
    }

    public Boolean hasMountPropagation() {
        return this.mountPropagation != null;
    }

    public A withNewMountPropagation(StringBuilder arg1) {
        return (A)withMountPropagation(new String(arg1));
    }

    public A withNewMountPropagation(int[] arg1,int arg2,int arg3) {
        return (A)withMountPropagation(new String(arg1, arg2, arg3));
    }

    public A withNewMountPropagation(char[] arg1) {
        return (A)withMountPropagation(new String(arg1));
    }

    public A withNewMountPropagation(StringBuffer arg1) {
        return (A)withMountPropagation(new String(arg1));
    }

    public A withNewMountPropagation(byte[] arg1,int arg2) {
        return (A)withMountPropagation(new String(arg1, arg2));
    }

    public A withNewMountPropagation(byte[] arg1) {
        return (A)withMountPropagation(new String(arg1));
    }

    public A withNewMountPropagation(char[] arg1,int arg2,int arg3) {
        return (A)withMountPropagation(new String(arg1, arg2, arg3));
    }

    public A withNewMountPropagation(byte[] arg1,int arg2,int arg3) {
        return (A)withMountPropagation(new String(arg1, arg2, arg3));
    }

    public A withNewMountPropagation(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMountPropagation(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMountPropagation(String arg1) {
        return (A)withMountPropagation(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public String getSubPath() {
        return this.subPath;
    }

    public A withSubPath(String subPath) {
        this.subPath=subPath; return (A) this;
    }

    public Boolean hasSubPath() {
        return this.subPath != null;
    }

    public A withNewSubPath(StringBuilder arg1) {
        return (A)withSubPath(new String(arg1));
    }

    public A withNewSubPath(int[] arg1,int arg2,int arg3) {
        return (A)withSubPath(new String(arg1, arg2, arg3));
    }

    public A withNewSubPath(char[] arg1) {
        return (A)withSubPath(new String(arg1));
    }

    public A withNewSubPath(StringBuffer arg1) {
        return (A)withSubPath(new String(arg1));
    }

    public A withNewSubPath(byte[] arg1,int arg2) {
        return (A)withSubPath(new String(arg1, arg2));
    }

    public A withNewSubPath(byte[] arg1) {
        return (A)withSubPath(new String(arg1));
    }

    public A withNewSubPath(char[] arg1,int arg2,int arg3) {
        return (A)withSubPath(new String(arg1, arg2, arg3));
    }

    public A withNewSubPath(byte[] arg1,int arg2,int arg3) {
        return (A)withSubPath(new String(arg1, arg2, arg3));
    }

    public A withNewSubPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSubPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSubPath(String arg1) {
        return (A)withSubPath(new String(arg1));
    }

    public String getSubPathExpr() {
        return this.subPathExpr;
    }

    public A withSubPathExpr(String subPathExpr) {
        this.subPathExpr=subPathExpr; return (A) this;
    }

    public Boolean hasSubPathExpr() {
        return this.subPathExpr != null;
    }

    public A withNewSubPathExpr(StringBuilder arg1) {
        return (A)withSubPathExpr(new String(arg1));
    }

    public A withNewSubPathExpr(int[] arg1,int arg2,int arg3) {
        return (A)withSubPathExpr(new String(arg1, arg2, arg3));
    }

    public A withNewSubPathExpr(char[] arg1) {
        return (A)withSubPathExpr(new String(arg1));
    }

    public A withNewSubPathExpr(StringBuffer arg1) {
        return (A)withSubPathExpr(new String(arg1));
    }

    public A withNewSubPathExpr(byte[] arg1,int arg2) {
        return (A)withSubPathExpr(new String(arg1, arg2));
    }

    public A withNewSubPathExpr(byte[] arg1) {
        return (A)withSubPathExpr(new String(arg1));
    }

    public A withNewSubPathExpr(char[] arg1,int arg2,int arg3) {
        return (A)withSubPathExpr(new String(arg1, arg2, arg3));
    }

    public A withNewSubPathExpr(byte[] arg1,int arg2,int arg3) {
        return (A)withSubPathExpr(new String(arg1, arg2, arg3));
    }

    public A withNewSubPathExpr(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSubPathExpr(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSubPathExpr(String arg1) {
        return (A)withSubPathExpr(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VolumeMountFluentImpl that = (VolumeMountFluentImpl) o;
        if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
        if (mountPropagation != null ? !mountPropagation.equals(that.mountPropagation) :that.mountPropagation != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (subPath != null ? !subPath.equals(that.subPath) :that.subPath != null) return false;
        if (subPathExpr != null ? !subPathExpr.equals(that.subPathExpr) :that.subPathExpr != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(mountPath,  mountPropagation,  name,  readOnly,  subPath,  subPathExpr,  super.hashCode());
    }

}
