package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class APIServiceStatusFluentImpl<A extends APIServiceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServiceStatusFluent<A> {

    private List<APIServiceConditionBuilder> conditions =  new ArrayList<APIServiceConditionBuilder>();

    public APIServiceStatusFluentImpl() {
    }

    public APIServiceStatusFluentImpl(APIServiceStatus instance) {
        this.withConditions(instance.getConditions()); 
    }

    public A addToConditions(int index,APIServiceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<APIServiceConditionBuilder>();}
        APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,APIServiceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<APIServiceConditionBuilder>();}
        APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(APIServiceCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<APIServiceConditionBuilder>();}
        for (APIServiceCondition item : items) {APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<APIServiceCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<APIServiceConditionBuilder>();}
        for (APIServiceCondition item : items) {APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(APIServiceCondition... items) {
        for (APIServiceCondition item : items) {APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<APIServiceCondition> items) {
        for (APIServiceCondition item : items) {APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<APIServiceConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<APIServiceConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          APIServiceConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServiceCondition> getConditions() {
        return build(conditions);
    }

    public List<APIServiceCondition> buildConditions() {
        return build(conditions);
    }

    public APIServiceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public APIServiceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public APIServiceCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public APIServiceCondition buildMatchingCondition(Predicate<APIServiceConditionBuilder> predicate) {
        for (APIServiceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<APIServiceConditionBuilder> predicate) {
        for (APIServiceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<APIServiceCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<APIServiceConditionBuilder>(); for (APIServiceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(APIServiceCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (APIServiceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new APIServiceCondition(lastTransitionTime, message, reason, status, type));
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> addNewConditionLike(APIServiceCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,APIServiceCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<APIServiceConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServiceStatusFluentImpl that = (APIServiceStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends APIServiceConditionFluentImpl<io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.APIServiceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,APIServiceCondition item) {
                this.index = index;
                this.builder = new APIServiceConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new APIServiceConditionBuilder(this);
                        
            }

            public N and() {
                return (N) APIServiceStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
