package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodSecurityContextFluent<A extends PodSecurityContextFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Long getFsGroup();
    public A withFsGroup(Long fsGroup);
    public Boolean hasFsGroup();
    public A withNewFsGroup(long arg1);
    public String getFsGroupChangePolicy();
    public A withFsGroupChangePolicy(String fsGroupChangePolicy);
    public Boolean hasFsGroupChangePolicy();
    public A withNewFsGroupChangePolicy(StringBuilder arg1);
    public A withNewFsGroupChangePolicy(int[] arg1,int arg2,int arg3);
    public A withNewFsGroupChangePolicy(char[] arg1);
    public A withNewFsGroupChangePolicy(StringBuffer arg1);
    public A withNewFsGroupChangePolicy(byte[] arg1,int arg2);
    public A withNewFsGroupChangePolicy(byte[] arg1);
    public A withNewFsGroupChangePolicy(char[] arg1,int arg2,int arg3);
    public A withNewFsGroupChangePolicy(byte[] arg1,int arg2,int arg3);
    public A withNewFsGroupChangePolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewFsGroupChangePolicy(String arg1);
    public Long getRunAsGroup();
    public A withRunAsGroup(Long runAsGroup);
    public Boolean hasRunAsGroup();
    public A withNewRunAsGroup(long arg1);
    public Boolean getRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Boolean hasRunAsNonRoot();
    public A withNewRunAsNonRoot(String arg1);
    public A withNewRunAsNonRoot(boolean arg1);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public Boolean hasRunAsUser();
    public A withNewRunAsUser(long arg1);
    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public SELinuxOptions getSeLinuxOptions();
    public SELinuxOptions buildSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public Boolean hasSeLinuxOptions();
    public A withNewSeLinuxOptions(String level,String role,String type,String user);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item);
    
/**
 * This method has been deprecated, please use method buildSeccompProfile instead.
 * @return The buildable object.
 */
@Deprecated public SeccompProfile getSeccompProfile();
    public SeccompProfile buildSeccompProfile();
    public A withSeccompProfile(SeccompProfile seccompProfile);
    public Boolean hasSeccompProfile();
    public A withNewSeccompProfile(String localhostProfile,String type);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> editSeccompProfile();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item);
    public A addToSupplementalGroups(int index,Long item);
    public A setToSupplementalGroups(int index,Long item);
    public A addToSupplementalGroups(Long... items);
    public A addAllToSupplementalGroups(Collection<Long> items);
    public A removeFromSupplementalGroups(Long... items);
    public A removeAllFromSupplementalGroups(Collection<Long> items);
    public List<Long> getSupplementalGroups();
    public Long getSupplementalGroup(int index);
    public Long getFirstSupplementalGroup();
    public Long getLastSupplementalGroup();
    public Long getMatchingSupplementalGroup(Predicate<Long> predicate);
    public Boolean hasMatchingSupplementalGroup(Predicate<Long> predicate);
    public A withSupplementalGroups(List<Long> supplementalGroups);
    public A withSupplementalGroups(Long... supplementalGroups);
    public Boolean hasSupplementalGroups();
    public A addNewSupplementalGroup(long arg1);
    public A addToSysctls(int index,Sysctl item);
    public A setToSysctls(int index,Sysctl item);
    public A addToSysctls(Sysctl... items);
    public A addAllToSysctls(Collection<Sysctl> items);
    public A removeFromSysctls(Sysctl... items);
    public A removeAllFromSysctls(Collection<Sysctl> items);
    public A removeMatchingFromSysctls(Predicate<SysctlBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSysctls instead.
 * @return The buildable object.
 */
@Deprecated public List<Sysctl> getSysctls();
    public List<Sysctl> buildSysctls();
    public Sysctl buildSysctl(int index);
    public Sysctl buildFirstSysctl();
    public Sysctl buildLastSysctl();
    public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate);
    public Boolean hasMatchingSysctl(Predicate<SysctlBuilder> predicate);
    public A withSysctls(List<Sysctl> sysctls);
    public A withSysctls(Sysctl... sysctls);
    public Boolean hasSysctls();
    public A addNewSysctl(String name,String value);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> addNewSysctl();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(Sysctl item);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index,Sysctl item);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editLastSysctl();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildWindowsOptions instead.
 * @return The buildable object.
 */
@Deprecated public WindowsSecurityContextOptions getWindowsOptions();
    public WindowsSecurityContextOptions buildWindowsOptions();
    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions);
    public Boolean hasWindowsOptions();
    public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,String runAsUserName);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item);
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions();
    public io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item);
    public interface SeLinuxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxOptionsFluent<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeLinuxOptionsNested<N>> {

            public N and();
            public N endSeLinuxOptions();    }


    public interface SeccompProfileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SeccompProfileFluent<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SeccompProfileNested<N>> {

            public N and();
            public N endSeccompProfile();    }


    public interface SysctlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SysctlFluent<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.SysctlsNested<N>> {

            public N and();
            public N endSysctl();    }


    public interface WindowsOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WindowsSecurityContextOptionsFluent<io.fabric8.kubernetes.api.model.PodSecurityContextFluent.WindowsOptionsNested<N>> {

            public N and();
            public N endWindowsOptions();    }


}
