package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodStatusFluent<A extends PodStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConditions(int index,PodCondition item);
    public A setToConditions(int index,PodCondition item);
    public A addToConditions(PodCondition... items);
    public A addAllToConditions(Collection<PodCondition> items);
    public A removeFromConditions(PodCondition... items);
    public A removeAllFromConditions(Collection<PodCondition> items);
    public A removeMatchingFromConditions(Predicate<PodConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<PodCondition> getConditions();
    public List<PodCondition> buildConditions();
    public PodCondition buildCondition(int index);
    public PodCondition buildFirstCondition();
    public PodCondition buildLastCondition();
    public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<PodConditionBuilder> predicate);
    public A withConditions(List<PodCondition> conditions);
    public A withConditions(PodCondition... conditions);
    public Boolean hasConditions();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index,PodCondition item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate);
    public A addToContainerStatuses(int index,ContainerStatus item);
    public A setToContainerStatuses(int index,ContainerStatus item);
    public A addToContainerStatuses(ContainerStatus... items);
    public A addAllToContainerStatuses(Collection<ContainerStatus> items);
    public A removeFromContainerStatuses(ContainerStatus... items);
    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items);
    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerStatus> getContainerStatuses();
    public List<ContainerStatus> buildContainerStatuses();
    public ContainerStatus buildContainerStatus(int index);
    public ContainerStatus buildFirstContainerStatus();
    public ContainerStatus buildLastContainerStatus();
    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public A withContainerStatuses(List<ContainerStatus> containerStatuses);
    public A withContainerStatuses(ContainerStatus... containerStatuses);
    public Boolean hasContainerStatuses();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public A addToEphemeralContainerStatuses(int index,ContainerStatus item);
    public A setToEphemeralContainerStatuses(int index,ContainerStatus item);
    public A addToEphemeralContainerStatuses(ContainerStatus... items);
    public A addAllToEphemeralContainerStatuses(Collection<ContainerStatus> items);
    public A removeFromEphemeralContainerStatuses(ContainerStatus... items);
    public A removeAllFromEphemeralContainerStatuses(Collection<ContainerStatus> items);
    public A removeMatchingFromEphemeralContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEphemeralContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerStatus> getEphemeralContainerStatuses();
    public List<ContainerStatus> buildEphemeralContainerStatuses();
    public ContainerStatus buildEphemeralContainerStatus(int index);
    public ContainerStatus buildFirstEphemeralContainerStatus();
    public ContainerStatus buildLastEphemeralContainerStatus();
    public ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public Boolean hasMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public A withEphemeralContainerStatuses(List<ContainerStatus> ephemeralContainerStatuses);
    public A withEphemeralContainerStatuses(ContainerStatus... ephemeralContainerStatuses);
    public Boolean hasEphemeralContainerStatuses();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index,ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public String getHostIP();
    public A withHostIP(String hostIP);
    public Boolean hasHostIP();
    public A withNewHostIP(StringBuilder arg1);
    public A withNewHostIP(int[] arg1,int arg2,int arg3);
    public A withNewHostIP(char[] arg1);
    public A withNewHostIP(StringBuffer arg1);
    public A withNewHostIP(byte[] arg1,int arg2);
    public A withNewHostIP(byte[] arg1);
    public A withNewHostIP(char[] arg1,int arg2,int arg3);
    public A withNewHostIP(byte[] arg1,int arg2,int arg3);
    public A withNewHostIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHostIP(String arg1);
    public A addToInitContainerStatuses(int index,ContainerStatus item);
    public A setToInitContainerStatuses(int index,ContainerStatus item);
    public A addToInitContainerStatuses(ContainerStatus... items);
    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items);
    public A removeFromInitContainerStatuses(ContainerStatus... items);
    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items);
    public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInitContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerStatus> getInitContainerStatuses();
    public List<ContainerStatus> buildInitContainerStatuses();
    public ContainerStatus buildInitContainerStatus(int index);
    public ContainerStatus buildFirstInitContainerStatus();
    public ContainerStatus buildLastInitContainerStatus();
    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public Boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses);
    public A withInitContainerStatuses(ContainerStatus... initContainerStatuses);
    public Boolean hasInitContainerStatuses();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index,ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public A withNewMessage(StringBuilder arg1);
    public A withNewMessage(int[] arg1,int arg2,int arg3);
    public A withNewMessage(char[] arg1);
    public A withNewMessage(StringBuffer arg1);
    public A withNewMessage(byte[] arg1,int arg2);
    public A withNewMessage(byte[] arg1);
    public A withNewMessage(char[] arg1,int arg2,int arg3);
    public A withNewMessage(byte[] arg1,int arg2,int arg3);
    public A withNewMessage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewMessage(String arg1);
    public String getNominatedNodeName();
    public A withNominatedNodeName(String nominatedNodeName);
    public Boolean hasNominatedNodeName();
    public A withNewNominatedNodeName(StringBuilder arg1);
    public A withNewNominatedNodeName(int[] arg1,int arg2,int arg3);
    public A withNewNominatedNodeName(char[] arg1);
    public A withNewNominatedNodeName(StringBuffer arg1);
    public A withNewNominatedNodeName(byte[] arg1,int arg2);
    public A withNewNominatedNodeName(byte[] arg1);
    public A withNewNominatedNodeName(char[] arg1,int arg2,int arg3);
    public A withNewNominatedNodeName(byte[] arg1,int arg2,int arg3);
    public A withNewNominatedNodeName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewNominatedNodeName(String arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(int[] arg1,int arg2,int arg3);
    public A withNewPhase(char[] arg1);
    public A withNewPhase(StringBuffer arg1);
    public A withNewPhase(byte[] arg1,int arg2);
    public A withNewPhase(byte[] arg1);
    public A withNewPhase(char[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPhase(String arg1);
    public String getPodIP();
    public A withPodIP(String podIP);
    public Boolean hasPodIP();
    public A withNewPodIP(StringBuilder arg1);
    public A withNewPodIP(int[] arg1,int arg2,int arg3);
    public A withNewPodIP(char[] arg1);
    public A withNewPodIP(StringBuffer arg1);
    public A withNewPodIP(byte[] arg1,int arg2);
    public A withNewPodIP(byte[] arg1);
    public A withNewPodIP(char[] arg1,int arg2,int arg3);
    public A withNewPodIP(byte[] arg1,int arg2,int arg3);
    public A withNewPodIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPodIP(String arg1);
    public A addToPodIPs(int index,PodIP item);
    public A setToPodIPs(int index,PodIP item);
    public A addToPodIPs(PodIP... items);
    public A addAllToPodIPs(Collection<PodIP> items);
    public A removeFromPodIPs(PodIP... items);
    public A removeAllFromPodIPs(Collection<PodIP> items);
    public A removeMatchingFromPodIPs(Predicate<PodIPBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPodIPs instead.
 * @return The buildable object.
 */
@Deprecated public List<PodIP> getPodIPs();
    public List<PodIP> buildPodIPs();
    public PodIP buildPodIP(int index);
    public PodIP buildFirstPodIP();
    public PodIP buildLastPodIP();
    public PodIP buildMatchingPodIP(Predicate<PodIPBuilder> predicate);
    public Boolean hasMatchingPodIP(Predicate<PodIPBuilder> predicate);
    public A withPodIPs(List<PodIP> podIPs);
    public A withPodIPs(PodIP... podIPs);
    public Boolean hasPodIPs();
    public A addNewPodIP(String ip);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> addNewPodIP();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> addNewPodIPLike(PodIP item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> setNewPodIPLike(int index,PodIP item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editPodIP(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editFirstPodIP();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editLastPodIP();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editMatchingPodIP(Predicate<PodIPBuilder> predicate);
    public String getQosClass();
    public A withQosClass(String qosClass);
    public Boolean hasQosClass();
    public A withNewQosClass(StringBuilder arg1);
    public A withNewQosClass(int[] arg1,int arg2,int arg3);
    public A withNewQosClass(char[] arg1);
    public A withNewQosClass(StringBuffer arg1);
    public A withNewQosClass(byte[] arg1,int arg2);
    public A withNewQosClass(byte[] arg1);
    public A withNewQosClass(char[] arg1,int arg2,int arg3);
    public A withNewQosClass(byte[] arg1,int arg2,int arg3);
    public A withNewQosClass(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewQosClass(String arg1);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public A withNewReason(StringBuilder arg1);
    public A withNewReason(int[] arg1,int arg2,int arg3);
    public A withNewReason(char[] arg1);
    public A withNewReason(StringBuffer arg1);
    public A withNewReason(byte[] arg1,int arg2);
    public A withNewReason(byte[] arg1);
    public A withNewReason(char[] arg1,int arg2,int arg3);
    public A withNewReason(byte[] arg1,int arg2,int arg3);
    public A withNewReason(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewReason(String arg1);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(StringBuilder arg1);
    public A withNewStartTime(int[] arg1,int arg2,int arg3);
    public A withNewStartTime(char[] arg1);
    public A withNewStartTime(StringBuffer arg1);
    public A withNewStartTime(byte[] arg1,int arg2);
    public A withNewStartTime(byte[] arg1);
    public A withNewStartTime(char[] arg1,int arg2,int arg3);
    public A withNewStartTime(byte[] arg1,int arg2,int arg3);
    public A withNewStartTime(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewStartTime(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodConditionFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStatusFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<N>> {

            public N and();
            public N endContainerStatus();    }


    public interface EphemeralContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStatusFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<N>> {

            public N and();
            public N endEphemeralContainerStatus();    }


    public interface InitContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStatusFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<N>> {

            public N and();
            public N endInitContainerStatus();    }


    public interface PodIPsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodIPFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<N>> {

            public N and();
            public N endPodIP();    }


}
