package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointsBuilder extends EndpointsFluentImpl<EndpointsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Endpoints,EndpointsBuilder> {

    EndpointsFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointsBuilder() {
        this(true);
    }

    public EndpointsBuilder(Boolean validationEnabled) {
        this(new Endpoints(), validationEnabled);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Endpoints(), validationEnabled);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent,Endpoints instance) {
        this(fluent, instance, true);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent,Endpoints instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSubsets(instance.getSubsets()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointsBuilder(Endpoints instance) {
        this(instance,true);
    }

    public EndpointsBuilder(Endpoints instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSubsets(instance.getSubsets()); 
        this.validationEnabled = validationEnabled; 
    }

    public Endpoints build() {
        Endpoints buildable = new Endpoints(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSubsets());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointsBuilder that = (EndpointsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
