package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ConfigFluent<A extends ConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToClusters(int index,NamedCluster item);
    public A setToClusters(int index,NamedCluster item);
    public A addToClusters(NamedCluster... items);
    public A addAllToClusters(Collection<NamedCluster> items);
    public A removeFromClusters(NamedCluster... items);
    public A removeAllFromClusters(Collection<NamedCluster> items);
    public A removeMatchingFromClusters(Predicate<NamedClusterBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildClusters instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedCluster> getClusters();
    public List<NamedCluster> buildClusters();
    public NamedCluster buildCluster(int index);
    public NamedCluster buildFirstCluster();
    public NamedCluster buildLastCluster();
    public NamedCluster buildMatchingCluster(Predicate<NamedClusterBuilder> predicate);
    public Boolean hasMatchingCluster(Predicate<NamedClusterBuilder> predicate);
    public A withClusters(List<NamedCluster> clusters);
    public A withClusters(NamedCluster... clusters);
    public Boolean hasClusters();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> addNewCluster();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> setNewClusterLike(int index,NamedCluster item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editCluster(int index);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editFirstCluster();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editLastCluster();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<A> editMatchingCluster(Predicate<NamedClusterBuilder> predicate);
    public A addToContexts(int index,NamedContext item);
    public A setToContexts(int index,NamedContext item);
    public A addToContexts(NamedContext... items);
    public A addAllToContexts(Collection<NamedContext> items);
    public A removeFromContexts(NamedContext... items);
    public A removeAllFromContexts(Collection<NamedContext> items);
    public A removeMatchingFromContexts(Predicate<NamedContextBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContexts instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedContext> getContexts();
    public List<NamedContext> buildContexts();
    public NamedContext buildContext(int index);
    public NamedContext buildFirstContext();
    public NamedContext buildLastContext();
    public NamedContext buildMatchingContext(Predicate<NamedContextBuilder> predicate);
    public Boolean hasMatchingContext(Predicate<NamedContextBuilder> predicate);
    public A withContexts(List<NamedContext> contexts);
    public A withContexts(NamedContext... contexts);
    public Boolean hasContexts();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> addNewContext();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> setNewContextLike(int index,NamedContext item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editContext(int index);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editFirstContext();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editLastContext();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<A> editMatchingContext(Predicate<NamedContextBuilder> predicate);
    public String getCurrentContext();
    public A withCurrentContext(String currentContext);
    public Boolean hasCurrentContext();
    public A withNewCurrentContext(StringBuilder arg1);
    public A withNewCurrentContext(int[] arg1,int arg2,int arg3);
    public A withNewCurrentContext(char[] arg1);
    public A withNewCurrentContext(StringBuffer arg1);
    public A withNewCurrentContext(byte[] arg1,int arg2);
    public A withNewCurrentContext(byte[] arg1);
    public A withNewCurrentContext(char[] arg1,int arg2,int arg3);
    public A withNewCurrentContext(byte[] arg1,int arg2,int arg3);
    public A withNewCurrentContext(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCurrentContext(String arg1);
    public A addToExtensions(int index,NamedExtension item);
    public A setToExtensions(int index,NamedExtension item);
    public A addToExtensions(NamedExtension... items);
    public A addAllToExtensions(Collection<NamedExtension> items);
    public A removeFromExtensions(NamedExtension... items);
    public A removeAllFromExtensions(Collection<NamedExtension> items);
    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildExtensions instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedExtension> getExtensions();
    public List<NamedExtension> buildExtensions();
    public NamedExtension buildExtension(int index);
    public NamedExtension buildFirstExtension();
    public NamedExtension buildLastExtension();
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public Boolean hasExtensions();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> addNewExtension();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editExtension(int index);
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editFirstExtension();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editLastExtension();
    public io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildPreferences instead.
 * @return The buildable object.
 */
@Deprecated public Preferences getPreferences();
    public Preferences buildPreferences();
    public A withPreferences(Preferences preferences);
    public Boolean hasPreferences();
    public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> withNewPreferences();
    public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editPreferences();
    public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editOrNewPreferences();
    public io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(Preferences item);
    public A addToUsers(int index,NamedAuthInfo item);
    public A setToUsers(int index,NamedAuthInfo item);
    public A addToUsers(NamedAuthInfo... items);
    public A addAllToUsers(Collection<NamedAuthInfo> items);
    public A removeFromUsers(NamedAuthInfo... items);
    public A removeAllFromUsers(Collection<NamedAuthInfo> items);
    public A removeMatchingFromUsers(Predicate<NamedAuthInfoBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildUsers instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedAuthInfo> getUsers();
    public List<NamedAuthInfo> buildUsers();
    public NamedAuthInfo buildUser(int index);
    public NamedAuthInfo buildFirstUser();
    public NamedAuthInfo buildLastUser();
    public NamedAuthInfo buildMatchingUser(Predicate<NamedAuthInfoBuilder> predicate);
    public Boolean hasMatchingUser(Predicate<NamedAuthInfoBuilder> predicate);
    public A withUsers(List<NamedAuthInfo> users);
    public A withUsers(NamedAuthInfo... users);
    public Boolean hasUsers();
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> addNewUser();
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> setNewUserLike(int index,NamedAuthInfo item);
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editUser(int index);
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editFirstUser();
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editLastUser();
    public io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<A> editMatchingUser(Predicate<NamedAuthInfoBuilder> predicate);
    public interface ClustersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedClusterFluent<io.fabric8.kubernetes.api.model.ConfigFluent.ClustersNested<N>> {

            public N and();
            public N endCluster();    }


    public interface ContextsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedContextFluent<io.fabric8.kubernetes.api.model.ConfigFluent.ContextsNested<N>> {

            public N and();
            public N endContext();    }


    public interface ExtensionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedExtensionFluent<io.fabric8.kubernetes.api.model.ConfigFluent.ExtensionsNested<N>> {

            public N and();
            public N endExtension();    }


    public interface PreferencesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PreferencesFluent<io.fabric8.kubernetes.api.model.ConfigFluent.PreferencesNested<N>> {

            public N and();
            public N endPreferences();    }


    public interface UsersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedAuthInfoFluent<io.fabric8.kubernetes.api.model.ConfigFluent.UsersNested<N>> {

            public N and();
            public N endUser();    }


}
