package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import java.lang.StringBuffer;

public interface ContainerFluent<A extends ContainerFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(Predicate<String> predicate);
    public Boolean hasMatchingArg(Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(int[] arg1,int arg2,int arg3);
    public A addNewArg(char[] arg1);
    public A addNewArg(StringBuffer arg1);
    public A addNewArg(byte[] arg1,int arg2);
    public A addNewArg(byte[] arg1);
    public A addNewArg(char[] arg1,int arg2,int arg3);
    public A addNewArg(byte[] arg1,int arg2,int arg3);
    public A addNewArg(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewArg(String arg1);
    public A addToCommand(int index,String item);
    public A setToCommand(int index,String item);
    public A addToCommand(String... items);
    public A addAllToCommand(Collection<String> items);
    public A removeFromCommand(String... items);
    public A removeAllFromCommand(Collection<String> items);
    public List<String> getCommand();
    public String getCommand(int index);
    public String getFirstCommand();
    public String getLastCommand();
    public String getMatchingCommand(Predicate<String> predicate);
    public Boolean hasMatchingCommand(Predicate<String> predicate);
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public Boolean hasCommand();
    public A addNewCommand(StringBuilder arg1);
    public A addNewCommand(int[] arg1,int arg2,int arg3);
    public A addNewCommand(char[] arg1);
    public A addNewCommand(StringBuffer arg1);
    public A addNewCommand(byte[] arg1,int arg2);
    public A addNewCommand(byte[] arg1);
    public A addNewCommand(char[] arg1,int arg2,int arg3);
    public A addNewCommand(byte[] arg1,int arg2,int arg3);
    public A addNewCommand(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewCommand(String arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvVar> getEnv();
    public List<EnvVar> buildEnv();
    public EnvVar buildEnv(int index);
    public EnvVar buildFirstEnv();
    public EnvVar buildLastEnv();
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> addNewEnv();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> setNewEnvLike(int index,EnvVar item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> editEnv(int index);
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> editFirstEnv();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> editLastEnv();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate);
    public A addToEnvFrom(int index,EnvFromSource item);
    public A setToEnvFrom(int index,EnvFromSource item);
    public A addToEnvFrom(EnvFromSource... items);
    public A addAllToEnvFrom(Collection<EnvFromSource> items);
    public A removeFromEnvFrom(EnvFromSource... items);
    public A removeAllFromEnvFrom(Collection<EnvFromSource> items);
    public A removeMatchingFromEnvFrom(Predicate<EnvFromSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnvFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvFromSource> getEnvFrom();
    public List<EnvFromSource> buildEnvFrom();
    public EnvFromSource buildEnvFrom(int index);
    public EnvFromSource buildFirstEnvFrom();
    public EnvFromSource buildLastEnvFrom();
    public EnvFromSource buildMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate);
    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate);
    public A withEnvFrom(List<EnvFromSource> envFrom);
    public A withEnvFrom(EnvFromSource... envFrom);
    public Boolean hasEnvFrom();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> addNewEnvFrom();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> addNewEnvFromLike(EnvFromSource item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index,EnvFromSource item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> editEnvFrom(int index);
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> editFirstEnvFrom();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> editLastEnvFrom();
    public io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<A> editMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getImagePullPolicy();
    public A withImagePullPolicy(String imagePullPolicy);
    public Boolean hasImagePullPolicy();
    public A withNewImagePullPolicy(StringBuilder arg1);
    public A withNewImagePullPolicy(int[] arg1,int arg2,int arg3);
    public A withNewImagePullPolicy(char[] arg1);
    public A withNewImagePullPolicy(StringBuffer arg1);
    public A withNewImagePullPolicy(byte[] arg1,int arg2);
    public A withNewImagePullPolicy(byte[] arg1);
    public A withNewImagePullPolicy(char[] arg1,int arg2,int arg3);
    public A withNewImagePullPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewImagePullPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImagePullPolicy(String arg1);
    
/**
 * This method has been deprecated, please use method buildLifecycle instead.
 * @return The buildable object.
 */
@Deprecated public Lifecycle getLifecycle();
    public Lifecycle buildLifecycle();
    public A withLifecycle(Lifecycle lifecycle);
    public Boolean hasLifecycle();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LifecycleNested<A> withNewLifecycle();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.LifecycleNested<A> editLifecycle();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LifecycleNested<A> editOrNewLifecycle();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item);
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.LivenessProbeNested<A> editLivenessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public A addToPorts(int index,ContainerPort item);
    public A setToPorts(int index,ContainerPort item);
    public A addToPorts(ContainerPort... items);
    public A addAllToPorts(Collection<ContainerPort> items);
    public A removeFromPorts(ContainerPort... items);
    public A removeAllFromPorts(Collection<ContainerPort> items);
    public A removeMatchingFromPorts(Predicate<ContainerPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerPort> getPorts();
    public List<ContainerPort> buildPorts();
    public ContainerPort buildPort(int index);
    public ContainerPort buildFirstPort();
    public ContainerPort buildLastPort();
    public ContainerPort buildMatchingPort(Predicate<ContainerPortBuilder> predicate);
    public Boolean hasMatchingPort(Predicate<ContainerPortBuilder> predicate);
    public A withPorts(List<ContainerPort> ports);
    public A withPorts(ContainerPort... ports);
    public Boolean hasPorts();
    public A addNewPort(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol);
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> addNewPort();
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> setNewPortLike(int index,ContainerPort item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> editPort(int index);
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> editFirstPort();
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> editLastPort();
    public io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<A> editMatchingPort(Predicate<ContainerPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.ReadinessProbeNested<A> editReadinessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ResourcesNested<A> withNewResources();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.ResourcesNested<A> editResources();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ResourcesNested<A> editOrNewResources();
    public io.fabric8.kubernetes.api.model.ContainerFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public SecurityContext getSecurityContext();
    public SecurityContext buildSecurityContext();
    public A withSecurityContext(SecurityContext securityContext);
    public Boolean hasSecurityContext();
    public io.fabric8.kubernetes.api.model.ContainerFluent.SecurityContextNested<A> withNewSecurityContext();
    public io.fabric8.kubernetes.api.model.ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.SecurityContextNested<A> editSecurityContext();
    public io.fabric8.kubernetes.api.model.ContainerFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public io.fabric8.kubernetes.api.model.ContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item);
    
/**
 * This method has been deprecated, please use method buildStartupProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getStartupProbe();
    public Probe buildStartupProbe();
    public A withStartupProbe(Probe startupProbe);
    public Boolean hasStartupProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.StartupProbeNested<A> withNewStartupProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(Probe item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.StartupProbeNested<A> editStartupProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.StartupProbeNested<A> editOrNewStartupProbe();
    public io.fabric8.kubernetes.api.model.ContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(Probe item);
    public Boolean getStdin();
    public A withStdin(Boolean stdin);
    public Boolean hasStdin();
    public A withNewStdin(String arg1);
    public A withNewStdin(boolean arg1);
    public Boolean getStdinOnce();
    public A withStdinOnce(Boolean stdinOnce);
    public Boolean hasStdinOnce();
    public A withNewStdinOnce(String arg1);
    public A withNewStdinOnce(boolean arg1);
    public String getTerminationMessagePath();
    public A withTerminationMessagePath(String terminationMessagePath);
    public Boolean hasTerminationMessagePath();
    public A withNewTerminationMessagePath(StringBuilder arg1);
    public A withNewTerminationMessagePath(int[] arg1,int arg2,int arg3);
    public A withNewTerminationMessagePath(char[] arg1);
    public A withNewTerminationMessagePath(StringBuffer arg1);
    public A withNewTerminationMessagePath(byte[] arg1,int arg2);
    public A withNewTerminationMessagePath(byte[] arg1);
    public A withNewTerminationMessagePath(char[] arg1,int arg2,int arg3);
    public A withNewTerminationMessagePath(byte[] arg1,int arg2,int arg3);
    public A withNewTerminationMessagePath(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTerminationMessagePath(String arg1);
    public String getTerminationMessagePolicy();
    public A withTerminationMessagePolicy(String terminationMessagePolicy);
    public Boolean hasTerminationMessagePolicy();
    public A withNewTerminationMessagePolicy(StringBuilder arg1);
    public A withNewTerminationMessagePolicy(int[] arg1,int arg2,int arg3);
    public A withNewTerminationMessagePolicy(char[] arg1);
    public A withNewTerminationMessagePolicy(StringBuffer arg1);
    public A withNewTerminationMessagePolicy(byte[] arg1,int arg2);
    public A withNewTerminationMessagePolicy(byte[] arg1);
    public A withNewTerminationMessagePolicy(char[] arg1,int arg2,int arg3);
    public A withNewTerminationMessagePolicy(byte[] arg1,int arg2,int arg3);
    public A withNewTerminationMessagePolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTerminationMessagePolicy(String arg1);
    public Boolean getTty();
    public A withTty(Boolean tty);
    public Boolean hasTty();
    public A withNewTty(String arg1);
    public A withNewTty(boolean arg1);
    public A addToVolumeDevices(int index,VolumeDevice item);
    public A setToVolumeDevices(int index,VolumeDevice item);
    public A addToVolumeDevices(VolumeDevice... items);
    public A addAllToVolumeDevices(Collection<VolumeDevice> items);
    public A removeFromVolumeDevices(VolumeDevice... items);
    public A removeAllFromVolumeDevices(Collection<VolumeDevice> items);
    public A removeMatchingFromVolumeDevices(Predicate<VolumeDeviceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeDevices instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeDevice> getVolumeDevices();
    public List<VolumeDevice> buildVolumeDevices();
    public VolumeDevice buildVolumeDevice(int index);
    public VolumeDevice buildFirstVolumeDevice();
    public VolumeDevice buildLastVolumeDevice();
    public VolumeDevice buildMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate);
    public Boolean hasMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate);
    public A withVolumeDevices(List<VolumeDevice> volumeDevices);
    public A withVolumeDevices(VolumeDevice... volumeDevices);
    public Boolean hasVolumeDevices();
    public A addNewVolumeDevice(String devicePath,String name);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(VolumeDevice item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index,VolumeDevice item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate);
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeMount> getVolumeMounts();
    public List<VolumeMount> buildVolumeMounts();
    public VolumeMount buildVolumeMount(int index);
    public VolumeMount buildFirstVolumeMount();
    public VolumeMount buildLastVolumeMount();
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> addNewVolumeMount();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> editVolumeMount(int index);
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> editFirstVolumeMount();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> editLastVolumeMount();
    public io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);
    public Boolean hasWorkingDir();
    public A withNewWorkingDir(StringBuilder arg1);
    public A withNewWorkingDir(int[] arg1,int arg2,int arg3);
    public A withNewWorkingDir(char[] arg1);
    public A withNewWorkingDir(StringBuffer arg1);
    public A withNewWorkingDir(byte[] arg1,int arg2);
    public A withNewWorkingDir(byte[] arg1);
    public A withNewWorkingDir(char[] arg1,int arg2,int arg3);
    public A withNewWorkingDir(byte[] arg1,int arg2,int arg3);
    public A withNewWorkingDir(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewWorkingDir(String arg1);
    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<io.fabric8.kubernetes.api.model.ContainerFluent.EnvNested<N>> {

            public N and();
            public N endEnv();    }


    public interface EnvFromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvFromSourceFluent<io.fabric8.kubernetes.api.model.ContainerFluent.EnvFromNested<N>> {

            public N and();
            public N endEnvFrom();    }


    public interface LifecycleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LifecycleFluent<io.fabric8.kubernetes.api.model.ContainerFluent.LifecycleNested<N>> {

            public N and();
            public N endLifecycle();    }


    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<io.fabric8.kubernetes.api.model.ContainerFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerPortFluent<io.fabric8.kubernetes.api.model.ContainerFluent.PortsNested<N>> {

            public N and();
            public N endPort();    }


    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<io.fabric8.kubernetes.api.model.ContainerFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<io.fabric8.kubernetes.api.model.ContainerFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


    public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextFluent<io.fabric8.kubernetes.api.model.ContainerFluent.SecurityContextNested<N>> {

            public N and();
            public N endSecurityContext();    }


    public interface StartupProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<io.fabric8.kubernetes.api.model.ContainerFluent.StartupProbeNested<N>> {

            public N and();
            public N endStartupProbe();    }


    public interface VolumeDevicesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeDeviceFluent<io.fabric8.kubernetes.api.model.ContainerFluent.VolumeDevicesNested<N>> {

            public N and();
            public N endVolumeDevice();    }


    public interface VolumeMountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeMountFluent<io.fabric8.kubernetes.api.model.ContainerFluent.VolumeMountsNested<N>> {

            public N and();
            public N endVolumeMount();    }


}
