package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DownwardAPIVolumeFileFluentImpl<A extends DownwardAPIVolumeFileFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DownwardAPIVolumeFileFluent<A> {

    private ObjectFieldSelectorBuilder fieldRef;
    private Integer mode;
    private String path;
    private ResourceFieldSelectorBuilder resourceFieldRef;

    public DownwardAPIVolumeFileFluentImpl() {
    }

    public DownwardAPIVolumeFileFluentImpl(DownwardAPIVolumeFile instance) {
        this.withFieldRef(instance.getFieldRef()); 
        this.withMode(instance.getMode()); 
        this.withPath(instance.getPath()); 
        this.withResourceFieldRef(instance.getResourceFieldRef()); 
    }

    
/**
 * This method has been deprecated, please use method buildFieldRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectFieldSelector getFieldRef() {
        return this.fieldRef!=null?this.fieldRef.build():null;
    }

    public ObjectFieldSelector buildFieldRef() {
        return this.fieldRef!=null?this.fieldRef.build():null;
    }

    public A withFieldRef(ObjectFieldSelector fieldRef) {
        _visitables.get("fieldRef").remove(this.fieldRef);
        if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.get("fieldRef").add(this.fieldRef);} return (A) this;
    }

    public Boolean hasFieldRef() {
        return this.fieldRef != null;
    }

    public A withNewFieldRef(String apiVersion,String fieldPath) {
        return (A)withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<A> withNewFieldRef() {
        return new FieldRefNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<A> withNewFieldRefLike(ObjectFieldSelector item) {
        return new FieldRefNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<A> editFieldRef() {
        return withNewFieldRefLike(getFieldRef());
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<A> editOrNewFieldRef() {
        return withNewFieldRefLike(getFieldRef() != null ? getFieldRef(): new ObjectFieldSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<A> editOrNewFieldRefLike(ObjectFieldSelector item) {
        return withNewFieldRefLike(getFieldRef() != null ? getFieldRef(): item);
    }

    public Integer getMode() {
        return this.mode;
    }

    public A withMode(Integer mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(int arg0) {
        return (A)withMode(new Integer(arg0));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(int[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(char[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(byte[] arg1,int arg2) {
        return (A)withPath(new String(arg1, arg2));
    }

    public A withNewPath(byte[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(char[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResourceFieldRef instead.
 * @return The buildable object.
 */
@Deprecated public ResourceFieldSelector getResourceFieldRef() {
        return this.resourceFieldRef!=null?this.resourceFieldRef.build():null;
    }

    public ResourceFieldSelector buildResourceFieldRef() {
        return this.resourceFieldRef!=null?this.resourceFieldRef.build():null;
    }

    public A withResourceFieldRef(ResourceFieldSelector resourceFieldRef) {
        _visitables.get("resourceFieldRef").remove(this.resourceFieldRef);
        if (resourceFieldRef!=null){ this.resourceFieldRef= new ResourceFieldSelectorBuilder(resourceFieldRef); _visitables.get("resourceFieldRef").add(this.resourceFieldRef);} return (A) this;
    }

    public Boolean hasResourceFieldRef() {
        return this.resourceFieldRef != null;
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> withNewResourceFieldRef() {
        return new ResourceFieldRefNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> withNewResourceFieldRefLike(ResourceFieldSelector item) {
        return new ResourceFieldRefNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> editResourceFieldRef() {
        return withNewResourceFieldRefLike(getResourceFieldRef());
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> editOrNewResourceFieldRef() {
        return withNewResourceFieldRefLike(getResourceFieldRef() != null ? getResourceFieldRef(): new ResourceFieldSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<A> editOrNewResourceFieldRefLike(ResourceFieldSelector item) {
        return withNewResourceFieldRefLike(getResourceFieldRef() != null ? getResourceFieldRef(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DownwardAPIVolumeFileFluentImpl that = (DownwardAPIVolumeFileFluentImpl) o;
        if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (resourceFieldRef != null ? !resourceFieldRef.equals(that.resourceFieldRef) :that.resourceFieldRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fieldRef,  mode,  path,  resourceFieldRef,  super.hashCode());
    }

    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<N>> implements io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.FieldRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectFieldSelectorBuilder builder;

            FieldRefNestedImpl(ObjectFieldSelector item) {
                this.builder = new ObjectFieldSelectorBuilder(this, item);
                        
            }

            FieldRefNestedImpl() {
                this.builder = new ObjectFieldSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) DownwardAPIVolumeFileFluentImpl.this.withFieldRef(builder.build());
            }

            public N endFieldRef() {
                return and();
            }
    }


    public class ResourceFieldRefNestedImpl<N> extends ResourceFieldSelectorFluentImpl<io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<N>> implements io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileFluent.ResourceFieldRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceFieldSelectorBuilder builder;

            ResourceFieldRefNestedImpl(ResourceFieldSelector item) {
                this.builder = new ResourceFieldSelectorBuilder(this, item);
                        
            }

            ResourceFieldRefNestedImpl() {
                this.builder = new ResourceFieldSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) DownwardAPIVolumeFileFluentImpl.this.withResourceFieldRef(builder.build());
            }

            public N endResourceFieldRef() {
                return and();
            }
    }


}
