package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface LoadBalancerIngressFluent<A extends LoadBalancerIngressFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(int[] arg1,int arg2,int arg3);
    public A withNewHostname(char[] arg1);
    public A withNewHostname(StringBuffer arg1);
    public A withNewHostname(byte[] arg1,int arg2);
    public A withNewHostname(byte[] arg1);
    public A withNewHostname(char[] arg1,int arg2,int arg3);
    public A withNewHostname(byte[] arg1,int arg2,int arg3);
    public A withNewHostname(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHostname(String arg1);
    public String getIp();
    public A withIp(String ip);
    public Boolean hasIp();
    public A withNewIp(StringBuilder arg1);
    public A withNewIp(int[] arg1,int arg2,int arg3);
    public A withNewIp(char[] arg1);
    public A withNewIp(StringBuffer arg1);
    public A withNewIp(byte[] arg1,int arg2);
    public A withNewIp(byte[] arg1);
    public A withNewIp(char[] arg1,int arg2,int arg3);
    public A withNewIp(byte[] arg1,int arg2,int arg3);
    public A withNewIp(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewIp(String arg1);
    public A addToPorts(int index,PortStatus item);
    public A setToPorts(int index,PortStatus item);
    public A addToPorts(PortStatus... items);
    public A addAllToPorts(Collection<PortStatus> items);
    public A removeFromPorts(PortStatus... items);
    public A removeAllFromPorts(Collection<PortStatus> items);
    public A removeMatchingFromPorts(Predicate<PortStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<PortStatus> getPorts();
    public List<PortStatus> buildPorts();
    public PortStatus buildPort(int index);
    public PortStatus buildFirstPort();
    public PortStatus buildLastPort();
    public PortStatus buildMatchingPort(Predicate<PortStatusBuilder> predicate);
    public Boolean hasMatchingPort(Predicate<PortStatusBuilder> predicate);
    public A withPorts(List<PortStatus> ports);
    public A withPorts(PortStatus... ports);
    public Boolean hasPorts();
    public A addNewPort(String error,Integer port,String protocol);
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> addNewPort();
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(PortStatus item);
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index,PortStatus item);
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editPort(int index);
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editFirstPort();
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editLastPort();
    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<PortStatusBuilder> predicate);
    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PortStatusFluent<io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<N>> {

            public N and();
            public N endPort();    }


}
