package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;

public class SecurityContextFluentImpl<A extends SecurityContextFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SecurityContextFluent<A> {

    private Boolean allowPrivilegeEscalation;
    private CapabilitiesBuilder capabilities;
    private Boolean privileged;
    private String procMount;
    private Boolean readOnlyRootFilesystem;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SELinuxOptionsBuilder seLinuxOptions;
    private SeccompProfileBuilder seccompProfile;
    private WindowsSecurityContextOptionsBuilder windowsOptions;

    public SecurityContextFluentImpl() {
    }

    public SecurityContextFluentImpl(SecurityContext instance) {
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
        this.withCapabilities(instance.getCapabilities()); 
        this.withPrivileged(instance.getPrivileged()); 
        this.withProcMount(instance.getProcMount()); 
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
        this.withRunAsGroup(instance.getRunAsGroup()); 
        this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
        this.withRunAsUser(instance.getRunAsUser()); 
        this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
        this.withSeccompProfile(instance.getSeccompProfile()); 
        this.withWindowsOptions(instance.getWindowsOptions()); 
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
    }

    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    public A withNewAllowPrivilegeEscalation(String arg1) {
        return (A)withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    public A withNewAllowPrivilegeEscalation(boolean arg1) {
        return (A)withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCapabilities instead.
 * @return The buildable object.
 */
@Deprecated public Capabilities getCapabilities() {
        return this.capabilities!=null?this.capabilities.build():null;
    }

    public Capabilities buildCapabilities() {
        return this.capabilities!=null?this.capabilities.build():null;
    }

    public A withCapabilities(Capabilities capabilities) {
        _visitables.get("capabilities").remove(this.capabilities);
        if (capabilities!=null){ this.capabilities= new CapabilitiesBuilder(capabilities); _visitables.get("capabilities").add(this.capabilities);} return (A) this;
    }

    public Boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item) {
        return new CapabilitiesNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> editCapabilities() {
        return withNewCapabilitiesLike(getCapabilities());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities() {
        return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): new CapabilitiesBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item) {
        return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): item);
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public A withPrivileged(Boolean privileged) {
        this.privileged=privileged; return (A) this;
    }

    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    public A withNewPrivileged(String arg1) {
        return (A)withPrivileged(new Boolean(arg1));
    }

    public A withNewPrivileged(boolean arg1) {
        return (A)withPrivileged(new Boolean(arg1));
    }

    public String getProcMount() {
        return this.procMount;
    }

    public A withProcMount(String procMount) {
        this.procMount=procMount; return (A) this;
    }

    public Boolean hasProcMount() {
        return this.procMount != null;
    }

    public A withNewProcMount(StringBuilder arg1) {
        return (A)withProcMount(new String(arg1));
    }

    public A withNewProcMount(int[] arg1,int arg2,int arg3) {
        return (A)withProcMount(new String(arg1, arg2, arg3));
    }

    public A withNewProcMount(char[] arg1) {
        return (A)withProcMount(new String(arg1));
    }

    public A withNewProcMount(StringBuffer arg1) {
        return (A)withProcMount(new String(arg1));
    }

    public A withNewProcMount(byte[] arg1,int arg2) {
        return (A)withProcMount(new String(arg1, arg2));
    }

    public A withNewProcMount(byte[] arg1) {
        return (A)withProcMount(new String(arg1));
    }

    public A withNewProcMount(char[] arg1,int arg2,int arg3) {
        return (A)withProcMount(new String(arg1, arg2, arg3));
    }

    public A withNewProcMount(byte[] arg1,int arg2,int arg3) {
        return (A)withProcMount(new String(arg1, arg2, arg3));
    }

    public A withNewProcMount(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withProcMount(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewProcMount(String arg1) {
        return (A)withProcMount(new String(arg1));
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }

    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    public A withNewReadOnlyRootFilesystem(String arg1) {
        return (A)withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    public A withNewReadOnlyRootFilesystem(boolean arg1) {
        return (A)withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup=runAsGroup; return (A) this;
    }

    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public A withNewRunAsGroup(long arg1) {
        return (A)withRunAsGroup(new Long(arg1));
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot=runAsNonRoot; return (A) this;
    }

    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public A withNewRunAsNonRoot(String arg1) {
        return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public A withNewRunAsNonRoot(boolean arg1) {
        return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser=runAsUser; return (A) this;
    }

    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public A withNewRunAsUser(long arg1) {
        return (A)withRunAsUser(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} return (A) this;
    }

    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public A withNewSeLinuxOptions(String level,String role,String type,String user) {
        return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new SELinuxOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
        return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSeccompProfile instead.
 * @return The buildable object.
 */
@Deprecated public SeccompProfile getSeccompProfile() {
        return this.seccompProfile!=null?this.seccompProfile.build():null;
    }

    public SeccompProfile buildSeccompProfile() {
        return this.seccompProfile!=null?this.seccompProfile.build():null;
    }

    public A withSeccompProfile(SeccompProfile seccompProfile) {
        _visitables.get("seccompProfile").remove(this.seccompProfile);
        if (seccompProfile!=null){ this.seccompProfile= new SeccompProfileBuilder(seccompProfile); _visitables.get("seccompProfile").add(this.seccompProfile);} return (A) this;
    }

    public Boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    public A withNewSeccompProfile(String localhostProfile,String type) {
        return (A)withSeccompProfile(new SeccompProfile(localhostProfile, type));
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
        return new SeccompProfileNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
        return withNewSeccompProfileLike(getSeccompProfile());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
        return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): new SeccompProfileBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
        return withNewSeccompProfileLike(getSeccompProfile() != null ? getSeccompProfile(): item);
    }

    
/**
 * This method has been deprecated, please use method buildWindowsOptions instead.
 * @return The buildable object.
 */
@Deprecated public WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions!=null?this.windowsOptions.build():null;
    }

    public WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions!=null?this.windowsOptions.build():null;
    }

    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
        _visitables.get("windowsOptions").remove(this.windowsOptions);
        if (windowsOptions!=null){ this.windowsOptions= new WindowsSecurityContextOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} return (A) this;
    }

    public Boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,String runAsUserName) {
        return (A)withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, runAsUserName));
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return new WindowsOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
        return withNewWindowsOptionsLike(getWindowsOptions());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): new WindowsSecurityContextOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return withNewWindowsOptionsLike(getWindowsOptions() != null ? getWindowsOptions(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecurityContextFluentImpl that = (SecurityContextFluentImpl) o;
        if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
        if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
        if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
        if (procMount != null ? !procMount.equals(that.procMount) :that.procMount != null) return false;
        if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
        if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
        if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
        if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
        if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
        if (seccompProfile != null ? !seccompProfile.equals(that.seccompProfile) :that.seccompProfile != null) return false;
        if (windowsOptions != null ? !windowsOptions.equals(that.windowsOptions) :that.windowsOptions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowPrivilegeEscalation,  capabilities,  privileged,  procMount,  readOnlyRootFilesystem,  runAsGroup,  runAsNonRoot,  runAsUser,  seLinuxOptions,  seccompProfile,  windowsOptions,  super.hashCode());
    }

    public class CapabilitiesNestedImpl<N> extends CapabilitiesFluentImpl<io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<N>> implements io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CapabilitiesBuilder builder;

            CapabilitiesNestedImpl(Capabilities item) {
                this.builder = new CapabilitiesBuilder(this, item);
                        
            }

            CapabilitiesNestedImpl() {
                this.builder = new CapabilitiesBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextFluentImpl.this.withCapabilities(builder.build());
            }

            public N endCapabilities() {
                return and();
            }
    }


    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<N>> implements io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SELinuxOptionsBuilder builder;

            SeLinuxOptionsNestedImpl(SELinuxOptions item) {
                this.builder = new SELinuxOptionsBuilder(this, item);
                        
            }

            SeLinuxOptionsNestedImpl() {
                this.builder = new SELinuxOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
            }

            public N endSeLinuxOptions() {
                return and();
            }
    }


    public class SeccompProfileNestedImpl<N> extends SeccompProfileFluentImpl<io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<N>> implements io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SeccompProfileBuilder builder;

            SeccompProfileNestedImpl(SeccompProfile item) {
                this.builder = new SeccompProfileBuilder(this, item);
                        
            }

            SeccompProfileNestedImpl() {
                this.builder = new SeccompProfileBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextFluentImpl.this.withSeccompProfile(builder.build());
            }

            public N endSeccompProfile() {
                return and();
            }
    }


    public class WindowsOptionsNestedImpl<N> extends WindowsSecurityContextOptionsFluentImpl<io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<N>> implements io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WindowsSecurityContextOptionsBuilder builder;

            WindowsOptionsNestedImpl(WindowsSecurityContextOptions item) {
                this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
                        
            }

            WindowsOptionsNestedImpl() {
                this.builder = new WindowsSecurityContextOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextFluentImpl.this.withWindowsOptions(builder.build());
            }

            public N endWindowsOptions() {
                return and();
            }
    }


}
