package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface LabelSelectorFluent<A extends LabelSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToMatchExpressions(int index,LabelSelectorRequirement item);
    public A setToMatchExpressions(int index,LabelSelectorRequirement item);
    public A addToMatchExpressions(LabelSelectorRequirement... items);
    public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items);
    public A removeFromMatchExpressions(LabelSelectorRequirement... items);
    public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items);
    public A removeMatchingFromMatchExpressions(Predicate<LabelSelectorRequirementBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMatchExpressions instead.
 * @return The buildable object.
 */
@Deprecated public List<LabelSelectorRequirement> getMatchExpressions();
    public List<LabelSelectorRequirement> buildMatchExpressions();
    public LabelSelectorRequirement buildMatchExpression(int index);
    public LabelSelectorRequirement buildFirstMatchExpression();
    public LabelSelectorRequirement buildLastMatchExpression();
    public LabelSelectorRequirement buildMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate);
    public Boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate);
    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions);
    public A withMatchExpressions(LabelSelectorRequirement... matchExpressions);
    public Boolean hasMatchExpressions();
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression();
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item);
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index,LabelSelectorRequirement item);
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editMatchExpression(int index);
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression();
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression();
    public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate);
    public A addToMatchLabels(String key,String value);
    public A addToMatchLabels(java.util.Map<String,String> map);
    public A removeFromMatchLabels(String key);
    public A removeFromMatchLabels(java.util.Map<String,String> map);
    public java.util.Map<String,String> getMatchLabels();
    public <K extends Object,V extends Object>A withMatchLabels(java.util.Map<String,String> matchLabels);
    public Boolean hasMatchLabels();
    public interface MatchExpressionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorRequirementFluent<io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<N>> {

            public N and();
            public N endMatchExpression();    }


}
