package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NamespaceListFluent<A extends NamespaceListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,Namespace item);
    public A setToItems(int index,Namespace item);
    public A addToItems(Namespace... items);
    public A addAllToItems(Collection<Namespace> items);
    public A removeFromItems(Namespace... items);
    public A removeAllFromItems(Collection<Namespace> items);
    public A removeMatchingFromItems(Predicate<NamespaceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Namespace> getItems();
    public List<Namespace> buildItems();
    public Namespace buildItem(int index);
    public Namespace buildFirstItem();
    public Namespace buildLastItem();
    public Namespace buildMatchingItem(Predicate<NamespaceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<NamespaceBuilder> predicate);
    public A withItems(List<Namespace> items);
    public A withItems(Namespace... items);
    public Boolean hasItems();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> addNewItem();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> addNewItemLike(Namespace item);
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> setNewItemLike(int index,Namespace item);
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> editLastItem();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<A> editMatchingItem(Predicate<NamespaceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.NamespaceListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceFluent<io.fabric8.kubernetes.api.model.NamespaceListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<io.fabric8.kubernetes.api.model.NamespaceListFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
