package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSIVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.CSIVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.CSIVolumeSource,io.fabric8.kubernetes.api.model.CSIVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CSIVolumeSourceBuilder() {
        this(true);
    }

    public CSIVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new CSIVolumeSource(), validationEnabled);
    }

    public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CSIVolumeSource(), validationEnabled);
    }

    public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CSIVolumeSource instance) {
        this(fluent, instance, true);
    }

    public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CSIVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDriver(instance.getDriver()); 
        fluent.withFsType(instance.getFsType()); 
        fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withVolumeAttributes(instance.getVolumeAttributes()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSource instance) {
        this(instance,true);
    }

    public CSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CSIVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDriver(instance.getDriver()); 
        this.withFsType(instance.getFsType()); 
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withVolumeAttributes(instance.getVolumeAttributes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.CSIVolumeSource build() {
        CSIVolumeSource buildable = new CSIVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getNodePublishSecretRef(),fluent.getReadOnly(),fluent.getVolumeAttributes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSIVolumeSourceBuilder that = (CSIVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
