package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

public class EphemeralContainerFluentImpl<A extends io.fabric8.kubernetes.api.model.EphemeralContainerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent<A> {

    private java.util.List<java.lang.String> args = new java.util.ArrayList<java.lang.String>();
    private java.util.List<java.lang.String> command = new java.util.ArrayList<java.lang.String>();
    private java.util.List<io.fabric8.kubernetes.api.model.EnvVarBuilder> env =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVarBuilder>();
    private java.util.List<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> envFrom =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>();
    private java.lang.String image;
    private java.lang.String imagePullPolicy;
    private io.fabric8.kubernetes.api.model.LifecycleBuilder lifecycle;
    private io.fabric8.kubernetes.api.model.ProbeBuilder livenessProbe;
    private java.lang.String name;
    private java.util.List<io.fabric8.kubernetes.api.model.ContainerPortBuilder> ports =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerPortBuilder>();
    private io.fabric8.kubernetes.api.model.ProbeBuilder readinessProbe;
    private io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder resources;
    private io.fabric8.kubernetes.api.model.SecurityContextBuilder securityContext;
    private io.fabric8.kubernetes.api.model.ProbeBuilder startupProbe;
    private java.lang.Boolean stdin;
    private java.lang.Boolean stdinOnce;
    private java.lang.String targetContainerName;
    private java.lang.String terminationMessagePath;
    private java.lang.String terminationMessagePolicy;
    private java.lang.Boolean tty;
    private java.util.List<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> volumeDevices =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>();
    private java.util.List<io.fabric8.kubernetes.api.model.VolumeMountBuilder> volumeMounts =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();
    private java.lang.String workingDir;

    public EphemeralContainerFluentImpl() {
    }

    public EphemeralContainerFluentImpl(io.fabric8.kubernetes.api.model.EphemeralContainer instance) {
        this.withArgs(instance.getArgs()); 
        this.withCommand(instance.getCommand()); 
        this.withEnv(instance.getEnv()); 
        this.withEnvFrom(instance.getEnvFrom()); 
        this.withImage(instance.getImage()); 
        this.withImagePullPolicy(instance.getImagePullPolicy()); 
        this.withLifecycle(instance.getLifecycle()); 
        this.withLivenessProbe(instance.getLivenessProbe()); 
        this.withName(instance.getName()); 
        this.withPorts(instance.getPorts()); 
        this.withReadinessProbe(instance.getReadinessProbe()); 
        this.withResources(instance.getResources()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withStartupProbe(instance.getStartupProbe()); 
        this.withStdin(instance.getStdin()); 
        this.withStdinOnce(instance.getStdinOnce()); 
        this.withTargetContainerName(instance.getTargetContainerName()); 
        this.withTerminationMessagePath(instance.getTerminationMessagePath()); 
        this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy()); 
        this.withTty(instance.getTty()); 
        this.withVolumeDevices(instance.getVolumeDevices()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withWorkingDir(instance.getWorkingDir()); 
    }

    public A addToArgs(int index,java.lang.String item) {
        if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
        this.args.add(index, item);
        return (A)this;
    }

    public A setToArgs(int index,java.lang.String item) {
        if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
        this.args.set(index, item); return (A)this;
    }

    public A addToArgs(java.lang.String... items) {
        if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.args.add(item);} return (A)this;
    }

    public A addAllToArgs(java.util.Collection<java.lang.String> items) {
        if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public A removeAllFromArgs(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getArgs() {
        return this.args;
    }

    public java.lang.String getArg(int index) {
        return this.args.get(index);
    }

    public java.lang.String getFirstArg() {
        return this.args.get(0);
    }

    public java.lang.String getLastArg() {
        return this.args.get(args.size() - 1);
    }

    public java.lang.String getMatchingArg(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: args) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingArg(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: args) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArgs(java.util.List<java.lang.String> args) {
        if (this.args != null) { _visitables.get("args").removeAll(this.args);}
        if (args != null) {this.args = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
    }

    public A withArgs(java.lang.String... args) {
        if (this.args != null) {this.args.clear();}
        if (args != null) {for (java.lang.String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public java.lang.Boolean hasArgs() {
        return args != null && !args.isEmpty();
    }

    public A addNewArg(java.lang.String arg0) {
        return (A)addToArgs(new String(arg0));
    }

    public A addToCommand(int index,java.lang.String item) {
        if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index,java.lang.String item) {
        if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
        this.command.set(index, item); return (A)this;
    }

    public A addToCommand(java.lang.String... items) {
        if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.command.add(item);} return (A)this;
    }

    public A addAllToCommand(java.util.Collection<java.lang.String> items) {
        if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.command.add(item);} return (A)this;
    }

    public A removeFromCommand(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public A removeAllFromCommand(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getCommand() {
        return this.command;
    }

    public java.lang.String getCommand(int index) {
        return this.command.get(index);
    }

    public java.lang.String getFirstCommand() {
        return this.command.get(0);
    }

    public java.lang.String getLastCommand() {
        return this.command.get(command.size() - 1);
    }

    public java.lang.String getMatchingCommand(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: command) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingCommand(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: command) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCommand(java.util.List<java.lang.String> command) {
        if (this.command != null) { _visitables.get("command").removeAll(this.command);}
        if (command != null) {this.command = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
    }

    public A withCommand(java.lang.String... command) {
        if (this.command != null) {this.command.clear();}
        if (command != null) {for (java.lang.String item :command){ this.addToCommand(item);}} return (A) this;
    }

    public java.lang.Boolean hasCommand() {
        return command != null && !command.isEmpty();
    }

    public A addNewCommand(java.lang.String arg0) {
        return (A)addToCommand(new String(arg0));
    }

    public A addToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVarBuilder>();}
        io.fabric8.kubernetes.api.model.EnvVarBuilder builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVarBuilder>();}
        io.fabric8.kubernetes.api.model.EnvVarBuilder builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(item);
        if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
        if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
         return (A)this;
    }

    public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVarBuilder>();}
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {io.fabric8.kubernetes.api.model.EnvVarBuilder builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVarBuilder>();}
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {io.fabric8.kubernetes.api.model.EnvVarBuilder builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {io.fabric8.kubernetes.api.model.EnvVarBuilder builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
        for (io.fabric8.kubernetes.api.model.EnvVar item : items) {io.fabric8.kubernetes.api.model.EnvVarBuilder builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate) {
        if (env == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.EnvVarBuilder> each = env.iterator();
        final List visitables = _visitables.get("env");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.EnvVarBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnv instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
        return build(env);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> buildEnv() {
        return build(env);
    }

    public io.fabric8.kubernetes.api.model.EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.EnvVar buildLastEnv() {
        return this.env.get(env.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.EnvVar buildMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVarBuilder>(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public java.lang.Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> addNewEnv() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.EnvNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> addNewEnvLike(io.fabric8.kubernetes.api.model.EnvVar item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.EnvNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> setNewEnvLike(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.EnvNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editEnv(int index) {
        if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editFirstEnv() {
        if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
        return setNewEnvLike(0, buildEnv(0));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editLastEnv() {
        int index = env.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate) {
        int index = -1;
        for (int i=0;i<env.size();i++) { 
        if (predicate.test(env.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public A addToEnvFrom(int index,io.fabric8.kubernetes.api.model.EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>();}
        io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(item);_visitables.get("envFrom").add(index >= 0 ? index : _visitables.get("envFrom").size(), builder);this.envFrom.add(index >= 0 ? index : envFrom.size(), builder); return (A)this;
    }

    public A setToEnvFrom(int index,io.fabric8.kubernetes.api.model.EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>();}
        io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("envFrom").size()) { _visitables.get("envFrom").add(builder); } else { _visitables.get("envFrom").set(index, builder);}
        if (index < 0 || index >= envFrom.size()) { envFrom.add(builder); } else { envFrom.set(index, builder);}
         return (A)this;
    }

    public A addToEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
        if (this.envFrom == null) {this.envFrom = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>();}
        for (io.fabric8.kubernetes.api.model.EnvFromSource item : items) {io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
    }

    public A addAllToEnvFrom(java.util.Collection<io.fabric8.kubernetes.api.model.EnvFromSource> items) {
        if (this.envFrom == null) {this.envFrom = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>();}
        for (io.fabric8.kubernetes.api.model.EnvFromSource item : items) {io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
    }

    public A removeFromEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
        for (io.fabric8.kubernetes.api.model.EnvFromSource item : items) {io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvFrom(java.util.Collection<io.fabric8.kubernetes.api.model.EnvFromSource> items) {
        for (io.fabric8.kubernetes.api.model.EnvFromSource item : items) {io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate) {
        if (envFrom == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> each = envFrom.iterator();
        final List visitables = _visitables.get("envFrom");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnvFrom instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EnvFromSource> getEnvFrom() {
        return build(envFrom);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.EnvFromSource> buildEnvFrom() {
        return build(envFrom);
    }

    public io.fabric8.kubernetes.api.model.EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(envFrom.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.EnvFromSource buildMatchingEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvFromSourceBuilder item: envFrom) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.EnvFromSourceBuilder item: envFrom) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnvFrom(java.util.List<io.fabric8.kubernetes.api.model.EnvFromSource> envFrom) {
        if (this.envFrom != null) { _visitables.get("envFrom").removeAll(this.envFrom);}
        if (envFrom != null) {this.envFrom = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder>(); for (io.fabric8.kubernetes.api.model.EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
    }

    public A withEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... envFrom) {
        if (this.envFrom != null) {this.envFrom.clear();}
        if (envFrom != null) {for (io.fabric8.kubernetes.api.model.EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
    }

    public java.lang.Boolean hasEnvFrom() {
        return envFrom != null && !envFrom.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> addNewEnvFrom() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.EnvFromNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> addNewEnvFromLike(io.fabric8.kubernetes.api.model.EnvFromSource item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.EnvFromNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index,io.fabric8.kubernetes.api.model.EnvFromSource item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.EnvFromNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editEnvFrom(int index) {
        if (envFrom.size() <= index) throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editFirstEnvFrom() {
        if (envFrom.size() == 0) throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        return setNewEnvFromLike(0, buildEnvFrom(0));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editLastEnvFrom() {
        int index = envFrom.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editMatchingEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<envFrom.size();i++) { 
        if (predicate.test(envFrom.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching envFrom. No match found.");
        return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String arg0) {
        return (A)withImage(new String(arg0));
    }

    public java.lang.String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(java.lang.String imagePullPolicy) {
        this.imagePullPolicy=imagePullPolicy; return (A) this;
    }

    public java.lang.Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImagePullPolicy instead.
     */
        public A withNewImagePullPolicy(java.lang.String arg0) {
        return (A)withImagePullPolicy(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLifecycle instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Lifecycle getLifecycle() {
        return this.lifecycle!=null?this.lifecycle.build():null;
    }

    public io.fabric8.kubernetes.api.model.Lifecycle buildLifecycle() {
        return this.lifecycle!=null?this.lifecycle.build():null;
    }

    public A withLifecycle(io.fabric8.kubernetes.api.model.Lifecycle lifecycle) {
        _visitables.get("lifecycle").remove(this.lifecycle);
        if (lifecycle!=null){ this.lifecycle= new io.fabric8.kubernetes.api.model.LifecycleBuilder(lifecycle); _visitables.get("lifecycle").add(this.lifecycle);} return (A) this;
    }

    public java.lang.Boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> withNewLifecycle() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.LifecycleNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> withNewLifecycleLike(io.fabric8.kubernetes.api.model.Lifecycle item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.LifecycleNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> editLifecycle() {
        return withNewLifecycleLike(getLifecycle());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycle() {
        return withNewLifecycleLike(getLifecycle() != null ? getLifecycle(): new io.fabric8.kubernetes.api.model.LifecycleBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(io.fabric8.kubernetes.api.model.Lifecycle item) {
        return withNewLifecycleLike(getLifecycle() != null ? getLifecycle(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.fabric8.kubernetes.api.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.fabric8.kubernetes.api.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.fabric8.kubernetes.api.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.LivenessProbeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.fabric8.kubernetes.api.model.Probe item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.fabric8.kubernetes.api.model.ProbeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.fabric8.kubernetes.api.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public A addToPorts(int index,io.fabric8.kubernetes.api.model.ContainerPort item) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerPortBuilder>();}
        io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,io.fabric8.kubernetes.api.model.ContainerPort item) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerPortBuilder>();}
        io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(item);
        if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
        if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
         return (A)this;
    }

    public A addToPorts(io.fabric8.kubernetes.api.model.ContainerPort... items) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerPortBuilder>();}
        for (io.fabric8.kubernetes.api.model.ContainerPort item : items) {io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerPort> items) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerPortBuilder>();}
        for (io.fabric8.kubernetes.api.model.ContainerPort item : items) {io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(io.fabric8.kubernetes.api.model.ContainerPort... items) {
        for (io.fabric8.kubernetes.api.model.ContainerPort item : items) {io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerPort> items) {
        for (io.fabric8.kubernetes.api.model.ContainerPort item : items) {io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate) {
        if (ports == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.ContainerPortBuilder> each = ports.iterator();
        final List visitables = _visitables.get("ports");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.ContainerPortBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPorts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ContainerPort> getPorts() {
        return build(ports);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.ContainerPort> buildPorts() {
        return build(ports);
    }

    public io.fabric8.kubernetes.api.model.ContainerPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.ContainerPort buildLastPort() {
        return this.ports.get(ports.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.ContainerPort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ContainerPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ContainerPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.ContainerPort> ports) {
        if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
        if (ports != null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerPortBuilder>(); for (io.fabric8.kubernetes.api.model.ContainerPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(io.fabric8.kubernetes.api.model.ContainerPort... ports) {
        if (this.ports != null) {this.ports.clear();}
        if (ports != null) {for (io.fabric8.kubernetes.api.model.ContainerPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public java.lang.Boolean hasPorts() {
        return ports != null && !ports.isEmpty();
    }

    public A addNewPort(java.lang.Integer containerPort,java.lang.String hostIP,java.lang.Integer hostPort,java.lang.String name,java.lang.String protocol) {
        return (A)addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> addNewPort() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.PortsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.ContainerPort item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.PortsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> setNewPortLike(int index,io.fabric8.kubernetes.api.model.ContainerPort item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.PortsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editPort(int index) {
        if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
        return setNewPortLike(index, buildPort(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editFirstPort() {
        if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
        return setNewPortLike(0, buildPort(0));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editLastPort() {
        int index = ports.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
        return setNewPortLike(index, buildPort(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ports.size();i++) { 
        if (predicate.test(ports.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
        return setNewPortLike(index, buildPort(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.fabric8.kubernetes.api.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.fabric8.kubernetes.api.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.fabric8.kubernetes.api.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.fabric8.kubernetes.api.model.Probe item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.fabric8.kubernetes.api.model.ProbeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.fabric8.kubernetes.api.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildResources instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> withNewResources() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.ResourcesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.ResourcesNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecurityContext instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.SecurityContext getSecurityContext() {
        return this.securityContext!=null?this.securityContext.build():null;
    }

    public io.fabric8.kubernetes.api.model.SecurityContext buildSecurityContext() {
        return this.securityContext!=null?this.securityContext.build():null;
    }

    public A withSecurityContext(io.fabric8.kubernetes.api.model.SecurityContext securityContext) {
        _visitables.get("securityContext").remove(this.securityContext);
        if (securityContext!=null){ this.securityContext= new io.fabric8.kubernetes.api.model.SecurityContextBuilder(securityContext); _visitables.get("securityContext").add(this.securityContext);} return (A) this;
    }

    public java.lang.Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.SecurityContextNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(io.fabric8.kubernetes.api.model.SecurityContext item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.SecurityContextNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> editSecurityContext() {
        return withNewSecurityContextLike(getSecurityContext());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new io.fabric8.kubernetes.api.model.SecurityContextBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(io.fabric8.kubernetes.api.model.SecurityContext item) {
        return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStartupProbe instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Probe getStartupProbe() {
        return this.startupProbe!=null?this.startupProbe.build():null;
    }

    public io.fabric8.kubernetes.api.model.Probe buildStartupProbe() {
        return this.startupProbe!=null?this.startupProbe.build():null;
    }

    public A withStartupProbe(io.fabric8.kubernetes.api.model.Probe startupProbe) {
        _visitables.get("startupProbe").remove(this.startupProbe);
        if (startupProbe!=null){ this.startupProbe= new io.fabric8.kubernetes.api.model.ProbeBuilder(startupProbe); _visitables.get("startupProbe").add(this.startupProbe);} return (A) this;
    }

    public java.lang.Boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbe() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.StartupProbeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(io.fabric8.kubernetes.api.model.Probe item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.StartupProbeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> editStartupProbe() {
        return withNewStartupProbeLike(getStartupProbe());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbe() {
        return withNewStartupProbeLike(getStartupProbe() != null ? getStartupProbe(): new io.fabric8.kubernetes.api.model.ProbeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(io.fabric8.kubernetes.api.model.Probe item) {
        return withNewStartupProbeLike(getStartupProbe() != null ? getStartupProbe(): item);
    }

    public java.lang.Boolean getStdin() {
        return this.stdin;
    }

    public A withStdin(java.lang.Boolean stdin) {
        this.stdin=stdin; return (A) this;
    }

    public java.lang.Boolean hasStdin() {
        return this.stdin != null;
    }

    public java.lang.Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public A withStdinOnce(java.lang.Boolean stdinOnce) {
        this.stdinOnce=stdinOnce; return (A) this;
    }

    public java.lang.Boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    public java.lang.String getTargetContainerName() {
        return this.targetContainerName;
    }

    public A withTargetContainerName(java.lang.String targetContainerName) {
        this.targetContainerName=targetContainerName; return (A) this;
    }

    public java.lang.Boolean hasTargetContainerName() {
        return this.targetContainerName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTargetContainerName instead.
     */
        public A withNewTargetContainerName(java.lang.String arg0) {
        return (A)withTargetContainerName(new String(arg0));
    }

    public java.lang.String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public A withTerminationMessagePath(java.lang.String terminationMessagePath) {
        this.terminationMessagePath=terminationMessagePath; return (A) this;
    }

    public java.lang.Boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTerminationMessagePath instead.
     */
        public A withNewTerminationMessagePath(java.lang.String arg0) {
        return (A)withTerminationMessagePath(new String(arg0));
    }

    public java.lang.String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public A withTerminationMessagePolicy(java.lang.String terminationMessagePolicy) {
        this.terminationMessagePolicy=terminationMessagePolicy; return (A) this;
    }

    public java.lang.Boolean hasTerminationMessagePolicy() {
        return this.terminationMessagePolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTerminationMessagePolicy instead.
     */
        public A withNewTerminationMessagePolicy(java.lang.String arg0) {
        return (A)withTerminationMessagePolicy(new String(arg0));
    }

    public java.lang.Boolean getTty() {
        return this.tty;
    }

    public A withTty(java.lang.Boolean tty) {
        this.tty=tty; return (A) this;
    }

    public java.lang.Boolean hasTty() {
        return this.tty != null;
    }

    public A addToVolumeDevices(int index,io.fabric8.kubernetes.api.model.VolumeDevice item) {
        if (this.volumeDevices == null) {this.volumeDevices = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(index >= 0 ? index : _visitables.get("volumeDevices").size(), builder);this.volumeDevices.add(index >= 0 ? index : volumeDevices.size(), builder); return (A)this;
    }

    public A setToVolumeDevices(int index,io.fabric8.kubernetes.api.model.VolumeDevice item) {
        if (this.volumeDevices == null) {this.volumeDevices = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(item);
        if (index < 0 || index >= _visitables.get("volumeDevices").size()) { _visitables.get("volumeDevices").add(builder); } else { _visitables.get("volumeDevices").set(index, builder);}
        if (index < 0 || index >= volumeDevices.size()) { volumeDevices.add(builder); } else { volumeDevices.set(index, builder);}
         return (A)this;
    }

    public A addToVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items) {
        if (this.volumeDevices == null) {this.volumeDevices = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeDevice item : items) {io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(builder);this.volumeDevices.add(builder);} return (A)this;
    }

    public A addAllToVolumeDevices(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeDevice> items) {
        if (this.volumeDevices == null) {this.volumeDevices = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeDevice item : items) {io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(builder);this.volumeDevices.add(builder);} return (A)this;
    }

    public A removeFromVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items) {
        for (io.fabric8.kubernetes.api.model.VolumeDevice item : items) {io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(item);_visitables.get("volumeDevices").remove(builder);if (this.volumeDevices != null) {this.volumeDevices.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeDevices(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeDevice> items) {
        for (io.fabric8.kubernetes.api.model.VolumeDevice item : items) {io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(item);_visitables.get("volumeDevices").remove(builder);if (this.volumeDevices != null) {this.volumeDevices.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeDevices(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate) {
        if (volumeDevices == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> each = volumeDevices.iterator();
        final List visitables = _visitables.get("volumeDevices");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumeDevices instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.VolumeDevice> getVolumeDevices() {
        return build(volumeDevices);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.VolumeDevice> buildVolumeDevices() {
        return build(volumeDevices);
    }

    public io.fabric8.kubernetes.api.model.VolumeDevice buildVolumeDevice(int index) {
        return this.volumeDevices.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeDevice buildFirstVolumeDevice() {
        return this.volumeDevices.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeDevice buildLastVolumeDevice() {
        return this.volumeDevices.get(volumeDevices.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeDevice buildMatchingVolumeDevice(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeDeviceBuilder item: volumeDevices) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingVolumeDevice(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeDeviceBuilder item: volumeDevices) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeDevices(java.util.List<io.fabric8.kubernetes.api.model.VolumeDevice> volumeDevices) {
        if (this.volumeDevices != null) { _visitables.get("volumeDevices").removeAll(this.volumeDevices);}
        if (volumeDevices != null) {this.volumeDevices = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder>(); for (io.fabric8.kubernetes.api.model.VolumeDevice item : volumeDevices){this.addToVolumeDevices(item);}} else { this.volumeDevices = null;} return (A) this;
    }

    public A withVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... volumeDevices) {
        if (this.volumeDevices != null) {this.volumeDevices.clear();}
        if (volumeDevices != null) {for (io.fabric8.kubernetes.api.model.VolumeDevice item :volumeDevices){ this.addToVolumeDevices(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumeDevices() {
        return volumeDevices != null && !volumeDevices.isEmpty();
    }

    public A addNewVolumeDevice(java.lang.String devicePath,java.lang.String name) {
        return (A)addToVolumeDevices(new VolumeDevice(devicePath, name));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.VolumeDevicesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(io.fabric8.kubernetes.api.model.VolumeDevice item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.VolumeDevicesNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index,io.fabric8.kubernetes.api.model.VolumeDevice item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.VolumeDevicesNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index) {
        if (volumeDevices.size() <= index) throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
        return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice() {
        if (volumeDevices.size() == 0) throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
        return setNewVolumeDeviceLike(0, buildVolumeDevice(0));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice() {
        int index = volumeDevices.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
        return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumeDevices.size();i++) { 
        if (predicate.test(volumeDevices.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
        return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
    }

    public A addToVolumeMounts(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
    }

    public A setToVolumeMounts(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);
        if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
        if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
         return (A)this;
    }

    public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A addAllToVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items) {
        for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeMounts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        if (volumeMounts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.VolumeMountBuilder> each = volumeMounts.iterator();
        final List visitables = _visitables.get("volumeMounts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.VolumeMountBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumeMounts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> getVolumeMounts() {
        return build(volumeMounts);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> buildVolumeMounts() {
        return build(volumeMounts);
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeMount buildMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMountBuilder>(); for (io.fabric8.kubernetes.api.model.VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (io.fabric8.kubernetes.api.model.VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.VolumeMountsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(io.fabric8.kubernetes.api.model.VolumeMount item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.VolumeMountsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
        return new io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl.VolumeMountsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        return setNewVolumeMountLike(0, buildVolumeMount(0));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = volumeMounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumeMounts.size();i++) { 
        if (predicate.test(volumeMounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public java.lang.String getWorkingDir() {
        return this.workingDir;
    }

    public A withWorkingDir(java.lang.String workingDir) {
        this.workingDir=workingDir; return (A) this;
    }

    public java.lang.Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withWorkingDir instead.
     */
        public A withNewWorkingDir(java.lang.String arg0) {
        return (A)withWorkingDir(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EphemeralContainerFluentImpl that = (EphemeralContainerFluentImpl) o;
        if (args != null ? !args.equals(that.args) :that.args != null) return false;
        if (command != null ? !command.equals(that.command) :that.command != null) return false;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (envFrom != null ? !envFrom.equals(that.envFrom) :that.envFrom != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
        if (lifecycle != null ? !lifecycle.equals(that.lifecycle) :that.lifecycle != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (startupProbe != null ? !startupProbe.equals(that.startupProbe) :that.startupProbe != null) return false;
        if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
        if (stdinOnce != null ? !stdinOnce.equals(that.stdinOnce) :that.stdinOnce != null) return false;
        if (targetContainerName != null ? !targetContainerName.equals(that.targetContainerName) :that.targetContainerName != null) return false;
        if (terminationMessagePath != null ? !terminationMessagePath.equals(that.terminationMessagePath) :that.terminationMessagePath != null) return false;
        if (terminationMessagePolicy != null ? !terminationMessagePolicy.equals(that.terminationMessagePolicy) :that.terminationMessagePolicy != null) return false;
        if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
        if (volumeDevices != null ? !volumeDevices.equals(that.volumeDevices) :that.volumeDevices != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(args,  command,  env,  envFrom,  image,  imagePullPolicy,  lifecycle,  livenessProbe,  name,  ports,  readinessProbe,  resources,  securityContext,  startupProbe,  stdin,  stdinOnce,  targetContainerName,  terminationMessagePath,  terminationMessagePolicy,  tty,  volumeDevices,  volumeMounts,  workingDir,  super.hashCode());
    }

    public class EnvNestedImpl<N> extends io.fabric8.kubernetes.api.model.EnvVarFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.EnvVarBuilder builder;
        private final int index;

            EnvNestedImpl(int index,io.fabric8.kubernetes.api.model.EnvVar item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(this, item);
                        
            }

            EnvNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.EnvVarBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.setToEnv(index,builder.build());
            }

            public N endEnv() {
                return and();
            }
    }


    public class EnvFromNestedImpl<N> extends io.fabric8.kubernetes.api.model.EnvFromSourceFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.EnvFromSourceBuilder builder;
        private final int index;

            EnvFromNestedImpl(int index,io.fabric8.kubernetes.api.model.EnvFromSource item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(this, item);
                        
            }

            EnvFromNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.EnvFromSourceBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.setToEnvFrom(index,builder.build());
            }

            public N endEnvFrom() {
                return and();
            }
    }


    public class LifecycleNestedImpl<N> extends io.fabric8.kubernetes.api.model.LifecycleFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LifecycleBuilder builder;

            LifecycleNestedImpl(io.fabric8.kubernetes.api.model.Lifecycle item) {
                this.builder = new io.fabric8.kubernetes.api.model.LifecycleBuilder(this, item);
                        
            }

            LifecycleNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LifecycleBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.withLifecycle(builder.build());
            }

            public N endLifecycle() {
                return and();
            }
    }


    public class LivenessProbeNestedImpl<N> extends io.fabric8.kubernetes.api.model.ProbeFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.fabric8.kubernetes.api.model.Probe item) {
                this.builder = new io.fabric8.kubernetes.api.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


    public class PortsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerPortFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ContainerPortBuilder builder;
        private final int index;

            PortsNestedImpl(int index,io.fabric8.kubernetes.api.model.ContainerPort item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(this, item);
                        
            }

            PortsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.ContainerPortBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.setToPorts(index,builder.build());
            }

            public N endPort() {
                return and();
            }
    }


    public class ReadinessProbeNestedImpl<N> extends io.fabric8.kubernetes.api.model.ProbeFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.fabric8.kubernetes.api.model.Probe item) {
                this.builder = new io.fabric8.kubernetes.api.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder builder;

            ResourcesNestedImpl(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
                this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


    public class SecurityContextNestedImpl<N> extends io.fabric8.kubernetes.api.model.SecurityContextFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.SecurityContextBuilder builder;

            SecurityContextNestedImpl(io.fabric8.kubernetes.api.model.SecurityContext item) {
                this.builder = new io.fabric8.kubernetes.api.model.SecurityContextBuilder(this, item);
                        
            }

            SecurityContextNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.SecurityContextBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.withSecurityContext(builder.build());
            }

            public N endSecurityContext() {
                return and();
            }
    }


    public class StartupProbeNestedImpl<N> extends io.fabric8.kubernetes.api.model.ProbeFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ProbeBuilder builder;

            StartupProbeNestedImpl(io.fabric8.kubernetes.api.model.Probe item) {
                this.builder = new io.fabric8.kubernetes.api.model.ProbeBuilder(this, item);
                        
            }

            StartupProbeNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.withStartupProbe(builder.build());
            }

            public N endStartupProbe() {
                return and();
            }
    }


    public class VolumeDevicesNestedImpl<N> extends io.fabric8.kubernetes.api.model.VolumeDeviceFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.VolumeDeviceBuilder builder;
        private final int index;

            VolumeDevicesNestedImpl(int index,io.fabric8.kubernetes.api.model.VolumeDevice item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(this, item);
                        
            }

            VolumeDevicesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeDeviceBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.setToVolumeDevices(index,builder.build());
            }

            public N endVolumeDevice() {
                return and();
            }
    }


    public class VolumeMountsNestedImpl<N> extends io.fabric8.kubernetes.api.model.VolumeMountFluentImpl<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<N>> implements io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.VolumeMountBuilder builder;
        private final int index;

            VolumeMountsNestedImpl(int index,io.fabric8.kubernetes.api.model.VolumeMount item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(this, item);
                        
            }

            VolumeMountsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeMountBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralContainerFluentImpl.this.setToVolumeMounts(index,builder.build());
            }

            public N endVolumeMount() {
                return and();
            }
    }


}
