package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KeyToPathBuilder extends io.fabric8.kubernetes.api.model.KeyToPathFluentImpl<io.fabric8.kubernetes.api.model.KeyToPathBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.KeyToPath,io.fabric8.kubernetes.api.model.KeyToPathBuilder> {

    io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KeyToPathBuilder() {
        this(true);
    }

    public KeyToPathBuilder(java.lang.Boolean validationEnabled) {
        this(new KeyToPath(), validationEnabled);
    }

    public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent) {
        this(fluent, true);
    }

    public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KeyToPath(), validationEnabled);
    }

    public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent,io.fabric8.kubernetes.api.model.KeyToPath instance) {
        this(fluent, instance, true);
    }

    public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent,io.fabric8.kubernetes.api.model.KeyToPath instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKey(instance.getKey()); 
        fluent.withMode(instance.getMode()); 
        fluent.withPath(instance.getPath()); 
        this.validationEnabled = validationEnabled; 
    }

    public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPath instance) {
        this(instance,true);
    }

    public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPath instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withKey(instance.getKey()); 
        this.withMode(instance.getMode()); 
        this.withPath(instance.getPath()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.KeyToPath build() {
        KeyToPath buildable = new KeyToPath(fluent.getKey(),fluent.getMode(),fluent.getPath());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KeyToPathBuilder that = (KeyToPathBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
