package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LimitRangeItemBuilder extends io.fabric8.kubernetes.api.model.LimitRangeItemFluentImpl<io.fabric8.kubernetes.api.model.LimitRangeItemBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LimitRangeItem,io.fabric8.kubernetes.api.model.LimitRangeItemBuilder> {

    io.fabric8.kubernetes.api.model.LimitRangeItemFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public LimitRangeItemBuilder() {
        this(true);
    }

    public LimitRangeItemBuilder(java.lang.Boolean validationEnabled) {
        this(new LimitRangeItem(), validationEnabled);
    }

    public LimitRangeItemBuilder(io.fabric8.kubernetes.api.model.LimitRangeItemFluent<?> fluent) {
        this(fluent, true);
    }

    public LimitRangeItemBuilder(io.fabric8.kubernetes.api.model.LimitRangeItemFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new LimitRangeItem(), validationEnabled);
    }

    public LimitRangeItemBuilder(io.fabric8.kubernetes.api.model.LimitRangeItemFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeItem instance) {
        this(fluent, instance, true);
    }

    public LimitRangeItemBuilder(io.fabric8.kubernetes.api.model.LimitRangeItemFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeItem instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDefault(instance.getDefault()); 
        fluent.withDefaultRequest(instance.getDefaultRequest()); 
        fluent.withMax(instance.getMax()); 
        fluent.withMaxLimitRequestRatio(instance.getMaxLimitRequestRatio()); 
        fluent.withMin(instance.getMin()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public LimitRangeItemBuilder(io.fabric8.kubernetes.api.model.LimitRangeItem instance) {
        this(instance,true);
    }

    public LimitRangeItemBuilder(io.fabric8.kubernetes.api.model.LimitRangeItem instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDefault(instance.getDefault()); 
        this.withDefaultRequest(instance.getDefaultRequest()); 
        this.withMax(instance.getMax()); 
        this.withMaxLimitRequestRatio(instance.getMaxLimitRequestRatio()); 
        this.withMin(instance.getMin()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.LimitRangeItem build() {
        LimitRangeItem buildable = new LimitRangeItem(fluent.getDefault(),fluent.getDefaultRequest(),fluent.getMax(),fluent.getMaxLimitRequestRatio(),fluent.getMin(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LimitRangeItemBuilder that = (LimitRangeItemBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
