package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LocalObjectReferenceBuilder extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LocalObjectReference,io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> {

    io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public LocalObjectReferenceBuilder() {
        this(true);
    }

    public LocalObjectReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new LocalObjectReference(), validationEnabled);
    }

    public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new LocalObjectReference(), validationEnabled);
    }

    public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalObjectReference instance) {
        this(fluent, instance, true);
    }

    public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalObjectReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReference instance) {
        this(instance,true);
    }

    public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference build() {
        LocalObjectReference buildable = new LocalObjectReference(fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LocalObjectReferenceBuilder that = (LocalObjectReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
