package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeSelectorBuilder extends io.fabric8.kubernetes.api.model.NodeSelectorFluentImpl<io.fabric8.kubernetes.api.model.NodeSelectorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeSelector,io.fabric8.kubernetes.api.model.NodeSelectorBuilder> {

    io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NodeSelectorBuilder() {
        this(true);
    }

    public NodeSelectorBuilder(java.lang.Boolean validationEnabled) {
        this(new NodeSelector(), validationEnabled);
    }

    public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent) {
        this(fluent, true);
    }

    public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NodeSelector(), validationEnabled);
    }

    public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelector instance) {
        this(fluent, instance, true);
    }

    public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelector instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelector instance) {
        this(instance,true);
    }

    public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelector instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withNodeSelectorTerms(instance.getNodeSelectorTerms()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.NodeSelector build() {
        NodeSelector buildable = new NodeSelector(fluent.getNodeSelectorTerms());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeSelectorBuilder that = (NodeSelectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
