package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodAffinityTermFluentImpl<A extends io.fabric8.kubernetes.api.model.PodAffinityTermFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.PodAffinityTermFluent<A> {

    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder labelSelector;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder namespaceSelector;
    private java.util.List<java.lang.String> namespaces = new java.util.ArrayList<java.lang.String>();
    private java.lang.String topologyKey;

    public PodAffinityTermFluentImpl() {
    }

    public PodAffinityTermFluentImpl(io.fabric8.kubernetes.api.model.PodAffinityTerm instance) {
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withNamespaces(instance.getNamespaces()); 
        this.withTopologyKey(instance.getTopologyKey()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLabelSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getLabelSelector() {
        return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildLabelSelector() {
        return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public A withLabelSelector(io.fabric8.kubernetes.api.model.LabelSelector labelSelector) {
        _visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector!=null){ this.labelSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} return (A) this;
    }

    public java.lang.Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new io.fabric8.kubernetes.api.model.PodAffinityTermFluentImpl.LabelSelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.kubernetes.api.model.PodAffinityTermFluentImpl.LabelSelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<A> editLabelSelector() {
        return withNewLabelSelectorLike(getLabelSelector());
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNamespaceSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public java.lang.Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new io.fabric8.kubernetes.api.model.PodAffinityTermFluentImpl.NamespaceSelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.kubernetes.api.model.PodAffinityTermFluentImpl.NamespaceSelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    public A addToNamespaces(int index,java.lang.String item) {
        if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index,java.lang.String item) {
        if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
        this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(java.lang.String... items) {
        if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(java.util.Collection<java.lang.String> items) {
        if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getNamespaces() {
        return this.namespaces;
    }

    public java.lang.String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public java.lang.String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public java.lang.String getLastNamespace() {
        return this.namespaces.get(namespaces.size() - 1);
    }

    public java.lang.String getMatchingNamespace(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingNamespace(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNamespaces(java.util.List<java.lang.String> namespaces) {
        if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
        if (namespaces != null) {this.namespaces = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(java.lang.String... namespaces) {
        if (this.namespaces != null) {this.namespaces.clear();}
        if (namespaces != null) {for (java.lang.String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public java.lang.Boolean hasNamespaces() {
        return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(java.lang.String arg0) {
        return (A)addToNamespaces(new String(arg0));
    }

    public java.lang.String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(java.lang.String topologyKey) {
        this.topologyKey=topologyKey; return (A) this;
    }

    public java.lang.Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTopologyKey instead.
     */
        public A withNewTopologyKey(java.lang.String arg0) {
        return (A)withTopologyKey(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodAffinityTermFluentImpl that = (PodAffinityTermFluentImpl) o;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
        if (topologyKey != null ? !topologyKey.equals(that.topologyKey) :that.topologyKey != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(labelSelector,  namespaceSelector,  namespaces,  topologyKey,  super.hashCode());
    }

    public class LabelSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<N>> implements io.fabric8.kubernetes.api.model.PodAffinityTermFluent.LabelSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            LabelSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            LabelSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PodAffinityTermFluentImpl.this.withLabelSelector(builder.build());
            }

            public N endLabelSelector() {
                return and();
            }
    }


    public class NamespaceSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<N>> implements io.fabric8.kubernetes.api.model.PodAffinityTermFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            NamespaceSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            NamespaceSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PodAffinityTermFluentImpl.this.withNamespaceSelector(builder.build());
            }

            public N endNamespaceSelector() {
                return and();
            }
    }


}
