package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodStatusFluent<A extends io.fabric8.kubernetes.api.model.PodStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConditions(int index,io.fabric8.kubernetes.api.model.PodCondition item);
    public A setToConditions(int index,io.fabric8.kubernetes.api.model.PodCondition item);
    public A addToConditions(io.fabric8.kubernetes.api.model.PodCondition... items);
    public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PodCondition> items);
    public A removeFromConditions(io.fabric8.kubernetes.api.model.PodCondition... items);
    public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PodCondition> items);
    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.PodCondition> getConditions();
    public java.util.List<io.fabric8.kubernetes.api.model.PodCondition> buildConditions();
    public io.fabric8.kubernetes.api.model.PodCondition buildCondition(int index);
    public io.fabric8.kubernetes.api.model.PodCondition buildFirstCondition();
    public io.fabric8.kubernetes.api.model.PodCondition buildLastCondition();
    public io.fabric8.kubernetes.api.model.PodCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate);
    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate);
    public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.PodCondition> conditions);
    public A withConditions(io.fabric8.kubernetes.api.model.PodCondition... conditions);
    public java.lang.Boolean hasConditions();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.PodCondition item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.kubernetes.api.model.PodCondition item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodConditionBuilder> predicate);
    public A addToContainerStatuses(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public A setToContainerStatuses(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public A addToContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
    public A addAllToContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items);
    public A removeFromContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
    public A removeAllFromContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items);
    public A removeMatchingFromContainerStatuses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildContainerStatuses instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> getContainerStatuses();
    public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> buildContainerStatuses();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.ContainerStatus buildFirstContainerStatus();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildLastContainerStatus();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildMatchingContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public java.lang.Boolean hasMatchingContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public A withContainerStatuses(java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> containerStatuses);
    public A withContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... containerStatuses);
    public java.lang.Boolean hasContainerStatuses();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public A addToEphemeralContainerStatuses(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public A setToEphemeralContainerStatuses(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public A addToEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
    public A addAllToEphemeralContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items);
    public A removeFromEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
    public A removeAllFromEphemeralContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items);
    public A removeMatchingFromEphemeralContainerStatuses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEphemeralContainerStatuses instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> getEphemeralContainerStatuses();
    public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> buildEphemeralContainerStatuses();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildEphemeralContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.ContainerStatus buildFirstEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildLastEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildMatchingEphemeralContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public java.lang.Boolean hasMatchingEphemeralContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public A withEphemeralContainerStatuses(java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> ephemeralContainerStatuses);
    public A withEphemeralContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... ephemeralContainerStatuses);
    public java.lang.Boolean hasEphemeralContainerStatuses();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public java.lang.String getHostIP();
    public A withHostIP(java.lang.String hostIP);
    public java.lang.Boolean hasHostIP();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHostIP instead.
     */
        public A withNewHostIP(java.lang.String arg0);
    public A addToInitContainerStatuses(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public A setToInitContainerStatuses(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public A addToInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
    public A addAllToInitContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items);
    public A removeFromInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... items);
    public A removeAllFromInitContainerStatuses(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerStatus> items);
    public A removeMatchingFromInitContainerStatuses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildInitContainerStatuses instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> getInitContainerStatuses();
    public java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> buildInitContainerStatuses();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildInitContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.ContainerStatus buildFirstInitContainerStatus();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildLastInitContainerStatus();
    public io.fabric8.kubernetes.api.model.ContainerStatus buildMatchingInitContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public java.lang.Boolean hasMatchingInitContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public A withInitContainerStatuses(java.util.List<io.fabric8.kubernetes.api.model.ContainerStatus> initContainerStatuses);
    public A withInitContainerStatuses(io.fabric8.kubernetes.api.model.ContainerStatus... initContainerStatuses);
    public java.lang.Boolean hasInitContainerStatuses();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(io.fabric8.kubernetes.api.model.ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index,io.fabric8.kubernetes.api.model.ContainerStatus item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> predicate);
    public java.lang.String getMessage();
    public A withMessage(java.lang.String message);
    public java.lang.Boolean hasMessage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMessage instead.
     */
        public A withNewMessage(java.lang.String arg0);
    public java.lang.String getNominatedNodeName();
    public A withNominatedNodeName(java.lang.String nominatedNodeName);
    public java.lang.Boolean hasNominatedNodeName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNominatedNodeName instead.
     */
        public A withNewNominatedNodeName(java.lang.String arg0);
    public java.lang.String getPhase();
    public A withPhase(java.lang.String phase);
    public java.lang.Boolean hasPhase();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPhase instead.
     */
        public A withNewPhase(java.lang.String arg0);
    public java.lang.String getPodIP();
    public A withPodIP(java.lang.String podIP);
    public java.lang.Boolean hasPodIP();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPodIP instead.
     */
        public A withNewPodIP(java.lang.String arg0);
    public A addToPodIPs(int index,io.fabric8.kubernetes.api.model.PodIP item);
    public A setToPodIPs(int index,io.fabric8.kubernetes.api.model.PodIP item);
    public A addToPodIPs(io.fabric8.kubernetes.api.model.PodIP... items);
    public A addAllToPodIPs(java.util.Collection<io.fabric8.kubernetes.api.model.PodIP> items);
    public A removeFromPodIPs(io.fabric8.kubernetes.api.model.PodIP... items);
    public A removeAllFromPodIPs(java.util.Collection<io.fabric8.kubernetes.api.model.PodIP> items);
    public A removeMatchingFromPodIPs(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodIPs instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.PodIP> getPodIPs();
    public java.util.List<io.fabric8.kubernetes.api.model.PodIP> buildPodIPs();
    public io.fabric8.kubernetes.api.model.PodIP buildPodIP(int index);
    public io.fabric8.kubernetes.api.model.PodIP buildFirstPodIP();
    public io.fabric8.kubernetes.api.model.PodIP buildLastPodIP();
    public io.fabric8.kubernetes.api.model.PodIP buildMatchingPodIP(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate);
    public java.lang.Boolean hasMatchingPodIP(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate);
    public A withPodIPs(java.util.List<io.fabric8.kubernetes.api.model.PodIP> podIPs);
    public A withPodIPs(io.fabric8.kubernetes.api.model.PodIP... podIPs);
    public java.lang.Boolean hasPodIPs();
    public A addNewPodIP(java.lang.String ip);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> addNewPodIP();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> addNewPodIPLike(io.fabric8.kubernetes.api.model.PodIP item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> setNewPodIPLike(int index,io.fabric8.kubernetes.api.model.PodIP item);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editPodIP(int index);
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editFirstPodIP();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editLastPodIP();
    public io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<A> editMatchingPodIP(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodIPBuilder> predicate);
    public java.lang.String getQosClass();
    public A withQosClass(java.lang.String qosClass);
    public java.lang.Boolean hasQosClass();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withQosClass instead.
     */
        public A withNewQosClass(java.lang.String arg0);
    public java.lang.String getReason();
    public A withReason(java.lang.String reason);
    public java.lang.Boolean hasReason();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withReason instead.
     */
        public A withNewReason(java.lang.String arg0);
    public java.lang.String getStartTime();
    public A withStartTime(java.lang.String startTime);
    public java.lang.Boolean hasStartTime();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withStartTime instead.
     */
        public A withNewStartTime(java.lang.String arg0);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PodConditionFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ContainerStatusFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.ContainerStatusesNested<N>> {

            public N and();
            public N endContainerStatus();    }


    public interface EphemeralContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ContainerStatusFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.EphemeralContainerStatusesNested<N>> {

            public N and();
            public N endEphemeralContainerStatus();    }


    public interface InitContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ContainerStatusFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.InitContainerStatusesNested<N>> {

            public N and();
            public N endInitContainerStatus();    }


    public interface PodIPsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PodIPFluent<io.fabric8.kubernetes.api.model.PodStatusFluent.PodIPsNested<N>> {

            public N and();
            public N endPodIP();    }


}
