package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodTemplateBuilder extends io.fabric8.kubernetes.api.model.PodTemplateFluentImpl<io.fabric8.kubernetes.api.model.PodTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodTemplate,io.fabric8.kubernetes.api.model.PodTemplateBuilder> {

    io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodTemplateBuilder() {
        this(true);
    }

    public PodTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplate instance) {
        this(fluent, instance, true);
    }

    public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplate instance) {
        this(instance,true);
    }

    public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.PodTemplate build() {
        PodTemplate buildable = new PodTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodTemplateBuilder that = (PodTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
