package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReplicationControllerListBuilder extends io.fabric8.kubernetes.api.model.ReplicationControllerListFluentImpl<io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ReplicationControllerList,io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder> {

    io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ReplicationControllerListBuilder() {
        this(true);
    }

    public ReplicationControllerListBuilder(java.lang.Boolean validationEnabled) {
        this(new ReplicationControllerList(), validationEnabled);
    }

    public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent) {
        this(fluent, true);
    }

    public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ReplicationControllerList(), validationEnabled);
    }

    public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerList instance) {
        this(fluent, instance, true);
    }

    public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerList instance) {
        this(instance,true);
    }

    public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ReplicationControllerList build() {
        ReplicationControllerList buildable = new ReplicationControllerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReplicationControllerListBuilder that = (ReplicationControllerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
