package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScaleIOVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ScaleIOVolumeSource,io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ScaleIOVolumeSourceBuilder() {
        this(true);
    }

    public ScaleIOVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ScaleIOVolumeSource(), validationEnabled);
    }

    public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ScaleIOVolumeSource(), validationEnabled);
    }

    public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance) {
        this(fluent, instance, true);
    }

    public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withGateway(instance.getGateway()); 
        fluent.withProtectionDomain(instance.getProtectionDomain()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withSslEnabled(instance.getSslEnabled()); 
        fluent.withStorageMode(instance.getStorageMode()); 
        fluent.withStoragePool(instance.getStoragePool()); 
        fluent.withSystem(instance.getSystem()); 
        fluent.withVolumeName(instance.getVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance) {
        this(instance,true);
    }

    public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withGateway(instance.getGateway()); 
        this.withProtectionDomain(instance.getProtectionDomain()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withSslEnabled(instance.getSslEnabled()); 
        this.withStorageMode(instance.getStorageMode()); 
        this.withStoragePool(instance.getStoragePool()); 
        this.withSystem(instance.getSystem()); 
        this.withVolumeName(instance.getVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ScaleIOVolumeSource build() {
        ScaleIOVolumeSource buildable = new ScaleIOVolumeSource(fluent.getFsType(),fluent.getGateway(),fluent.getProtectionDomain(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getSslEnabled(),fluent.getStorageMode(),fluent.getStoragePool(),fluent.getSystem(),fluent.getVolumeName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScaleIOVolumeSourceBuilder that = (ScaleIOVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
