package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ServiceAccountFluent<A extends io.fabric8.kubernetes.api.model.ServiceAccountFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getApiVersion();
    public A withApiVersion(java.lang.String apiVersion);
    public java.lang.Boolean hasApiVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0);
    public java.lang.Boolean getAutomountServiceAccountToken();
    public A withAutomountServiceAccountToken(java.lang.Boolean automountServiceAccountToken);
    public java.lang.Boolean hasAutomountServiceAccountToken();
    public A addToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
    public A setToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
    public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
    public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items);
    public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items);
    public A removeMatchingFromImagePullSecrets(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildImagePullSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets();
    public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> buildImagePullSecrets();
    public io.fabric8.kubernetes.api.model.LocalObjectReference buildImagePullSecret(int index);
    public io.fabric8.kubernetes.api.model.LocalObjectReference buildFirstImagePullSecret();
    public io.fabric8.kubernetes.api.model.LocalObjectReference buildLastImagePullSecret();
    public io.fabric8.kubernetes.api.model.LocalObjectReference buildMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
    public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
    public java.lang.Boolean hasImagePullSecrets();
    public A addNewImagePullSecret(java.lang.String name);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
    public java.lang.String getKind();
    public A withKind(java.lang.String kind);
    public java.lang.Boolean hasKind();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata();
    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata();
    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata);
    public java.lang.Boolean hasMetadata();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
    public A addToSecrets(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public A setToSecrets(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public A addToSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items);
    public A addAllToSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items);
    public A removeFromSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items);
    public A removeAllFromSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items);
    public A removeMatchingFromSecrets(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> getSecrets();
    public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> buildSecrets();
    public io.fabric8.kubernetes.api.model.ObjectReference buildSecret(int index);
    public io.fabric8.kubernetes.api.model.ObjectReference buildFirstSecret();
    public io.fabric8.kubernetes.api.model.ObjectReference buildLastSecret();
    public io.fabric8.kubernetes.api.model.ObjectReference buildMatchingSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate);
    public java.lang.Boolean hasMatchingSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate);
    public A withSecrets(java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> secrets);
    public A withSecrets(io.fabric8.kubernetes.api.model.ObjectReference... secrets);
    public java.lang.Boolean hasSecrets();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> addNewSecret();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> addNewSecretLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> setNewSecretLike(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editSecret(int index);
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editFirstSecret();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editLastSecret();
    public io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<A> editMatchingSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate);
    public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<io.fabric8.kubernetes.api.model.ServiceAccountFluent.ImagePullSecretsNested<N>> {

            public N and();
            public N endImagePullSecret();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ObjectMetaFluent<io.fabric8.kubernetes.api.model.ServiceAccountFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ObjectReferenceFluent<io.fabric8.kubernetes.api.model.ServiceAccountFluent.SecretsNested<N>> {

            public N and();
            public N endSecret();    }


}
