package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

public interface BaseKubernetesListFluent<A extends io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getApiVersion();
    public A withApiVersion(java.lang.String apiVersion);
    public java.lang.Boolean hasApiVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0);
    public A addToItems(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder);
    public A addToItems(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder);
    public A addToItems(int index,io.fabric8.kubernetes.api.model.HasMetadata item);
    public A setToItems(int index,io.fabric8.kubernetes.api.model.HasMetadata item);
    public A addToItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
    public A addAllToItems(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items);
    public A removeFromItems(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder);
    public A removeFromItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
    public A removeAllFromItems(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildItems instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> getItems();
    public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> buildItems();
    public io.fabric8.kubernetes.api.model.HasMetadata buildItem(int index);
    public io.fabric8.kubernetes.api.model.HasMetadata buildFirstItem();
    public io.fabric8.kubernetes.api.model.HasMetadata buildLastItem();
    public io.fabric8.kubernetes.api.model.HasMetadata buildMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public A withItems(java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> items);
    public A withItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
    public java.lang.Boolean hasItems();
    public A addToLimitRangeItems(int index,io.fabric8.kubernetes.api.model.LimitRange item);
    public A setToLimitRangeItems(int index,io.fabric8.kubernetes.api.model.LimitRange item);
    public A addToLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items);
    public A addAllToLimitRangeItems(java.util.Collection<io.fabric8.kubernetes.api.model.LimitRange> items);
    public A removeFromLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items);
    public A removeAllFromLimitRangeItems(java.util.Collection<io.fabric8.kubernetes.api.model.LimitRange> items);
    public A removeMatchingFromLimitRangeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(int index,io.fabric8.kubernetes.api.model.LimitRange item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(io.fabric8.kubernetes.api.model.LimitRange item);
    public A addToAPIServiceItems(int index,io.fabric8.kubernetes.api.model.APIService item);
    public A setToAPIServiceItems(int index,io.fabric8.kubernetes.api.model.APIService item);
    public A addToAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items);
    public A addAllToAPIServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.APIService> items);
    public A removeFromAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items);
    public A removeAllFromAPIServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.APIService> items);
    public A removeMatchingFromAPIServiceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> setNewAPIServiceItemLike(int index,io.fabric8.kubernetes.api.model.APIService item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItemLike(io.fabric8.kubernetes.api.model.APIService item);
    public A addToNamespaceItems(int index,io.fabric8.kubernetes.api.model.Namespace item);
    public A setToNamespaceItems(int index,io.fabric8.kubernetes.api.model.Namespace item);
    public A addToNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items);
    public A addAllToNamespaceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Namespace> items);
    public A removeFromNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items);
    public A removeAllFromNamespaceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Namespace> items);
    public A removeMatchingFromNamespaceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(int index,io.fabric8.kubernetes.api.model.Namespace item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(io.fabric8.kubernetes.api.model.Namespace item);
    public A addToServiceItems(int index,io.fabric8.kubernetes.api.model.Service item);
    public A setToServiceItems(int index,io.fabric8.kubernetes.api.model.Service item);
    public A addToServiceItems(io.fabric8.kubernetes.api.model.Service... items);
    public A addAllToServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Service> items);
    public A removeFromServiceItems(io.fabric8.kubernetes.api.model.Service... items);
    public A removeAllFromServiceItems(java.util.Collection<io.fabric8.kubernetes.api.model.Service> items);
    public A removeMatchingFromServiceItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(int index,io.fabric8.kubernetes.api.model.Service item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(io.fabric8.kubernetes.api.model.Service item);
    public A addToReplicationControllerItems(int index,io.fabric8.kubernetes.api.model.ReplicationController item);
    public A setToReplicationControllerItems(int index,io.fabric8.kubernetes.api.model.ReplicationController item);
    public A addToReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
    public A addAllToReplicationControllerItems(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationController> items);
    public A removeFromReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
    public A removeAllFromReplicationControllerItems(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationController> items);
    public A removeMatchingFromReplicationControllerItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(int index,io.fabric8.kubernetes.api.model.ReplicationController item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(io.fabric8.kubernetes.api.model.ReplicationController item);
    public A addToPodTemplateItems(int index,io.fabric8.kubernetes.api.model.PodTemplate item);
    public A setToPodTemplateItems(int index,io.fabric8.kubernetes.api.model.PodTemplate item);
    public A addToPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
    public A addAllToPodTemplateItems(java.util.Collection<io.fabric8.kubernetes.api.model.PodTemplate> items);
    public A removeFromPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
    public A removeAllFromPodTemplateItems(java.util.Collection<io.fabric8.kubernetes.api.model.PodTemplate> items);
    public A removeMatchingFromPodTemplateItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(int index,io.fabric8.kubernetes.api.model.PodTemplate item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(io.fabric8.kubernetes.api.model.PodTemplate item);
    public A addToEventItems(int index,io.fabric8.kubernetes.api.model.Event item);
    public A setToEventItems(int index,io.fabric8.kubernetes.api.model.Event item);
    public A addToEventItems(io.fabric8.kubernetes.api.model.Event... items);
    public A addAllToEventItems(java.util.Collection<io.fabric8.kubernetes.api.model.Event> items);
    public A removeFromEventItems(io.fabric8.kubernetes.api.model.Event... items);
    public A removeAllFromEventItems(java.util.Collection<io.fabric8.kubernetes.api.model.Event> items);
    public A removeMatchingFromEventItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> setNewEventItemLike(int index,io.fabric8.kubernetes.api.model.Event item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(io.fabric8.kubernetes.api.model.Event item);
    public A addToPersistentVolumeItems(int index,io.fabric8.kubernetes.api.model.PersistentVolume item);
    public A setToPersistentVolumeItems(int index,io.fabric8.kubernetes.api.model.PersistentVolume item);
    public A addToPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
    public A addAllToPersistentVolumeItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolume> items);
    public A removeFromPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
    public A removeAllFromPersistentVolumeItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolume> items);
    public A removeMatchingFromPersistentVolumeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(int index,io.fabric8.kubernetes.api.model.PersistentVolume item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(io.fabric8.kubernetes.api.model.PersistentVolume item);
    public A addToPersistentVolumeClaimItems(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public A setToPersistentVolumeClaimItems(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public A addToPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
    public A addAllToPersistentVolumeClaimItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
    public A removeFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
    public A removeAllFromPersistentVolumeClaimItems(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
    public A removeMatchingFromPersistentVolumeClaimItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public A addToEndpointsItems(int index,io.fabric8.kubernetes.api.model.Endpoints item);
    public A setToEndpointsItems(int index,io.fabric8.kubernetes.api.model.Endpoints item);
    public A addToEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items);
    public A addAllToEndpointsItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items);
    public A removeFromEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items);
    public A removeAllFromEndpointsItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items);
    public A removeMatchingFromEndpointsItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(int index,io.fabric8.kubernetes.api.model.Endpoints item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(io.fabric8.kubernetes.api.model.Endpoints item);
    public A addToPodItems(int index,io.fabric8.kubernetes.api.model.Pod item);
    public A setToPodItems(int index,io.fabric8.kubernetes.api.model.Pod item);
    public A addToPodItems(io.fabric8.kubernetes.api.model.Pod... items);
    public A addAllToPodItems(java.util.Collection<io.fabric8.kubernetes.api.model.Pod> items);
    public A removeFromPodItems(io.fabric8.kubernetes.api.model.Pod... items);
    public A removeAllFromPodItems(java.util.Collection<io.fabric8.kubernetes.api.model.Pod> items);
    public A removeMatchingFromPodItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(int index,io.fabric8.kubernetes.api.model.Pod item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(io.fabric8.kubernetes.api.model.Pod item);
    public A addToConfigMapItems(int index,io.fabric8.kubernetes.api.model.ConfigMap item);
    public A setToConfigMapItems(int index,io.fabric8.kubernetes.api.model.ConfigMap item);
    public A addToConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
    public A addAllToConfigMapItems(java.util.Collection<io.fabric8.kubernetes.api.model.ConfigMap> items);
    public A removeFromConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
    public A removeAllFromConfigMapItems(java.util.Collection<io.fabric8.kubernetes.api.model.ConfigMap> items);
    public A removeMatchingFromConfigMapItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(int index,io.fabric8.kubernetes.api.model.ConfigMap item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(io.fabric8.kubernetes.api.model.ConfigMap item);
    public A addToComponentStatusItems(int index,io.fabric8.kubernetes.api.model.ComponentStatus item);
    public A setToComponentStatusItems(int index,io.fabric8.kubernetes.api.model.ComponentStatus item);
    public A addToComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
    public A addAllToComponentStatusItems(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentStatus> items);
    public A removeFromComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
    public A removeAllFromComponentStatusItems(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentStatus> items);
    public A removeMatchingFromComponentStatusItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(int index,io.fabric8.kubernetes.api.model.ComponentStatus item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(io.fabric8.kubernetes.api.model.ComponentStatus item);
    public A addToBindingItems(int index,io.fabric8.kubernetes.api.model.Binding item);
    public A setToBindingItems(int index,io.fabric8.kubernetes.api.model.Binding item);
    public A addToBindingItems(io.fabric8.kubernetes.api.model.Binding... items);
    public A addAllToBindingItems(java.util.Collection<io.fabric8.kubernetes.api.model.Binding> items);
    public A removeFromBindingItems(io.fabric8.kubernetes.api.model.Binding... items);
    public A removeAllFromBindingItems(java.util.Collection<io.fabric8.kubernetes.api.model.Binding> items);
    public A removeMatchingFromBindingItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(int index,io.fabric8.kubernetes.api.model.Binding item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(io.fabric8.kubernetes.api.model.Binding item);
    public A addToResourceQuotaItems(int index,io.fabric8.kubernetes.api.model.ResourceQuota item);
    public A setToResourceQuotaItems(int index,io.fabric8.kubernetes.api.model.ResourceQuota item);
    public A addToResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
    public A addAllToResourceQuotaItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items);
    public A removeFromResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
    public A removeAllFromResourceQuotaItems(java.util.Collection<io.fabric8.kubernetes.api.model.ResourceQuota> items);
    public A removeMatchingFromResourceQuotaItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(int index,io.fabric8.kubernetes.api.model.ResourceQuota item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(io.fabric8.kubernetes.api.model.ResourceQuota item);
    public A addToSecretItems(int index,io.fabric8.kubernetes.api.model.Secret item);
    public A setToSecretItems(int index,io.fabric8.kubernetes.api.model.Secret item);
    public A addToSecretItems(io.fabric8.kubernetes.api.model.Secret... items);
    public A addAllToSecretItems(java.util.Collection<io.fabric8.kubernetes.api.model.Secret> items);
    public A removeFromSecretItems(io.fabric8.kubernetes.api.model.Secret... items);
    public A removeAllFromSecretItems(java.util.Collection<io.fabric8.kubernetes.api.model.Secret> items);
    public A removeMatchingFromSecretItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(int index,io.fabric8.kubernetes.api.model.Secret item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(io.fabric8.kubernetes.api.model.Secret item);
    public A addToNodeItems(int index,io.fabric8.kubernetes.api.model.Node item);
    public A setToNodeItems(int index,io.fabric8.kubernetes.api.model.Node item);
    public A addToNodeItems(io.fabric8.kubernetes.api.model.Node... items);
    public A addAllToNodeItems(java.util.Collection<io.fabric8.kubernetes.api.model.Node> items);
    public A removeFromNodeItems(io.fabric8.kubernetes.api.model.Node... items);
    public A removeAllFromNodeItems(java.util.Collection<io.fabric8.kubernetes.api.model.Node> items);
    public A removeMatchingFromNodeItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(int index,io.fabric8.kubernetes.api.model.Node item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(io.fabric8.kubernetes.api.model.Node item);
    public A addToServiceAccountItems(int index,io.fabric8.kubernetes.api.model.ServiceAccount item);
    public A setToServiceAccountItems(int index,io.fabric8.kubernetes.api.model.ServiceAccount item);
    public A addToServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
    public A addAllToServiceAccountItems(java.util.Collection<io.fabric8.kubernetes.api.model.ServiceAccount> items);
    public A removeFromServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
    public A removeAllFromServiceAccountItems(java.util.Collection<io.fabric8.kubernetes.api.model.ServiceAccount> items);
    public A removeMatchingFromServiceAccountItems(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(int index,io.fabric8.kubernetes.api.model.ServiceAccount item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(io.fabric8.kubernetes.api.model.ServiceAccount item);
    public java.lang.String getKind();
    public A withKind(java.lang.String kind);
    public java.lang.Boolean hasKind();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ListMeta getMetadata();
    public io.fabric8.kubernetes.api.model.ListMeta buildMetadata();
    public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata);
    public java.lang.Boolean hasMetadata();
    public A withNewMetadata(java.lang.String _continue,java.lang.Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item);
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item);
    public interface LimitRangeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.LimitRangeFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.LimitRangeItemsNested<N>> {

            public N and();
            public N endLimitRangeItem();    }


    public interface APIServiceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.APIServiceFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.APIServiceItemsNested<N>> {

            public N and();
            public N endAPIServiceItem();    }


    public interface NamespaceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.NamespaceFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NamespaceItemsNested<N>> {

            public N and();
            public N endNamespaceItem();    }


    public interface ServiceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ServiceFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceItemsNested<N>> {

            public N and();
            public N endServiceItem();    }


    public interface ReplicationControllerItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ReplicationControllerFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ReplicationControllerItemsNested<N>> {

            public N and();
            public N endReplicationControllerItem();    }


    public interface PodTemplateItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PodTemplateFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodTemplateItemsNested<N>> {

            public N and();
            public N endPodTemplateItem();    }


    public interface EventItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EventFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EventItemsNested<N>> {

            public N and();
            public N endEventItem();    }


    public interface PersistentVolumeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PersistentVolumeFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeItemsNested<N>> {

            public N and();
            public N endPersistentVolumeItem();    }


    public interface PersistentVolumeClaimItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>> {

            public N and();
            public N endPersistentVolumeClaimItem();    }


    public interface EndpointsItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EndpointsFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.EndpointsItemsNested<N>> {

            public N and();
            public N endEndpointsItem();    }


    public interface PodItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PodFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.PodItemsNested<N>> {

            public N and();
            public N endPodItem();    }


    public interface ConfigMapItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ConfigMapFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ConfigMapItemsNested<N>> {

            public N and();
            public N endConfigMapItem();    }


    public interface ComponentStatusItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ComponentStatusFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ComponentStatusItemsNested<N>> {

            public N and();
            public N endComponentStatusItem();    }


    public interface BindingItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.BindingFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.BindingItemsNested<N>> {

            public N and();
            public N endBindingItem();    }


    public interface ResourceQuotaItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ResourceQuotaFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ResourceQuotaItemsNested<N>> {

            public N and();
            public N endResourceQuotaItem();    }


    public interface SecretItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.SecretFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.SecretItemsNested<N>> {

            public N and();
            public N endSecretItem();    }


    public interface NodeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.NodeFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.NodeItemsNested<N>> {

            public N and();
            public N endNodeItem();    }


    public interface ServiceAccountItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ServiceAccountFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.ServiceAccountItemsNested<N>> {

            public N and();
            public N endServiceAccountItem();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ListMetaFluent<io.fabric8.kubernetes.api.model.BaseKubernetesListFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
