package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContextBuilder extends io.fabric8.kubernetes.api.model.ContextFluentImpl<io.fabric8.kubernetes.api.model.ContextBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Context,io.fabric8.kubernetes.api.model.ContextBuilder> {

    io.fabric8.kubernetes.api.model.ContextFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContextBuilder() {
        this(true);
    }

    public ContextBuilder(java.lang.Boolean validationEnabled) {
        this(new Context(), validationEnabled);
    }

    public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent) {
        this(fluent, true);
    }

    public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Context(), validationEnabled);
    }

    public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent,io.fabric8.kubernetes.api.model.Context instance) {
        this(fluent, instance, true);
    }

    public ContextBuilder(io.fabric8.kubernetes.api.model.ContextFluent<?> fluent,io.fabric8.kubernetes.api.model.Context instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCluster(instance.getCluster()); 
        fluent.withExtensions(instance.getExtensions()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContextBuilder(io.fabric8.kubernetes.api.model.Context instance) {
        this(instance,true);
    }

    public ContextBuilder(io.fabric8.kubernetes.api.model.Context instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCluster(instance.getCluster()); 
        this.withExtensions(instance.getExtensions()); 
        this.withNamespace(instance.getNamespace()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.Context build() {
        Context buildable = new Context(fluent.getCluster(),fluent.getExtensions(),fluent.getNamespace(),fluent.getUser());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContextBuilder that = (ContextBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
