package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NamespaceStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.NamespaceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.NamespaceStatusFluent<A> {

    private java.util.List<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();
    private java.lang.String phase;

    public NamespaceStatusFluentImpl() {
    }

    public NamespaceStatusFluentImpl(io.fabric8.kubernetes.api.model.NamespaceStatus instance) {
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
    }

    public A addToConditions(int index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
        io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
        io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.NamespaceCondition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
        for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.NamespaceCondition> items) {
        for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.kubernetes.api.model.NamespaceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.NamespaceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.NamespaceCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.NamespaceCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.NamespaceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.NamespaceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>(); for (io.fabric8.kubernetes.api.model.NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.kubernetes.api.model.NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
        return (A)addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.NamespaceCondition item) {
        return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
        return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public java.lang.String getPhase() {
        return this.phase;
    }

    public A withPhase(java.lang.String phase) {
        this.phase=phase; return (A) this;
    }

    public java.lang.Boolean hasPhase() {
        return this.phase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPhase instead.
     */
        public A withNewPhase(java.lang.String arg0) {
        return (A)withPhase(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NamespaceStatusFluentImpl that = (NamespaceStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  phase,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NamespaceConditionFluentImpl<io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(this);
                        
            }

            public N and() {
                return (N) NamespaceStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
