package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CinderVolumeSourceFluentImpl<A extends io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent<A> {

    private java.lang.String fsType;
    private java.lang.Boolean readOnly;
    private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder secretRef;
    private java.lang.String volumeID;

    public CinderVolumeSourceFluentImpl() {
    }

    public CinderVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.CinderVolumeSource instance) {
        this.withFsType(instance.getFsType()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withVolumeID(instance.getVolumeID()); 
    }

    public java.lang.String getFsType() {
        return this.fsType;
    }

    public A withFsType(java.lang.String fsType) {
        this.fsType=fsType; return (A) this;
    }

    public java.lang.Boolean hasFsType() {
        return this.fsType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFsType instead.
     */
        public A withNewFsType(java.lang.String arg0) {
        return (A)withFsType(new String(arg0));
    }

    public java.lang.Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(java.lang.Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public java.lang.Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecretRef instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LocalObjectReference getSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference secretRef) {
        _visitables.get("secretRef").remove(this.secretRef);
        if (secretRef!=null){ this.secretRef= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public java.lang.Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(java.lang.String name) {
        return (A)withSecretRef(new LocalObjectReference(name));
    }

    public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl.SecretRefNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl.SecretRefNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return withNewSecretRefLike(getSecretRef());
    }

    public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public java.lang.String getVolumeID() {
        return this.volumeID;
    }

    public A withVolumeID(java.lang.String volumeID) {
        this.volumeID=volumeID; return (A) this;
    }

    public java.lang.Boolean hasVolumeID() {
        return this.volumeID != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVolumeID instead.
     */
        public A withNewVolumeID(java.lang.String arg0) {
        return (A)withVolumeID(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CinderVolumeSourceFluentImpl that = (CinderVolumeSourceFluentImpl) o;
        if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
        if (volumeID != null ? !volumeID.equals(that.volumeID) :that.volumeID != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsType,  readOnly,  secretRef,  volumeID,  super.hashCode());
    }

    public class SecretRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<N>> implements io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent.SecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;

            SecretRefNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            SecretRefNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) CinderVolumeSourceFluentImpl.this.withSecretRef(builder.build());
            }

            public N endSecretRef() {
                return and();
            }
    }


}
