package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigBuilder extends io.fabric8.kubernetes.api.model.ConfigFluentImpl<io.fabric8.kubernetes.api.model.ConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Config,io.fabric8.kubernetes.api.model.ConfigBuilder> {

    io.fabric8.kubernetes.api.model.ConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConfigBuilder() {
        this(true);
    }

    public ConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(io.fabric8.kubernetes.api.model.ConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ConfigBuilder(io.fabric8.kubernetes.api.model.ConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(io.fabric8.kubernetes.api.model.ConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.Config instance) {
        this(fluent, instance, true);
    }

    public ConfigBuilder(io.fabric8.kubernetes.api.model.ConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.Config instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withClusters(instance.getClusters()); 
        fluent.withContexts(instance.getContexts()); 
        fluent.withCurrentContext(instance.getCurrentContext()); 
        fluent.withExtensions(instance.getExtensions()); 
        fluent.withKind(instance.getKind()); 
        fluent.withPreferences(instance.getPreferences()); 
        fluent.withUsers(instance.getUsers()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigBuilder(io.fabric8.kubernetes.api.model.Config instance) {
        this(instance,true);
    }

    public ConfigBuilder(io.fabric8.kubernetes.api.model.Config instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withClusters(instance.getClusters()); 
        this.withContexts(instance.getContexts()); 
        this.withCurrentContext(instance.getCurrentContext()); 
        this.withExtensions(instance.getExtensions()); 
        this.withKind(instance.getKind()); 
        this.withPreferences(instance.getPreferences()); 
        this.withUsers(instance.getUsers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.Config build() {
        Config buildable = new Config(fluent.getApiVersion(),fluent.getClusters(),fluent.getContexts(),fluent.getCurrentContext(),fluent.getExtensions(),fluent.getKind(),fluent.getPreferences(),fluent.getUsers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConfigBuilder that = (ConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
