package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GetOptionsBuilder extends io.fabric8.kubernetes.api.model.GetOptionsFluentImpl<io.fabric8.kubernetes.api.model.GetOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.GetOptions,io.fabric8.kubernetes.api.model.GetOptionsBuilder> {

    io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GetOptionsBuilder() {
        this(true);
    }

    public GetOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new GetOptions(), validationEnabled);
    }

    public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GetOptions(), validationEnabled);
    }

    public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.GetOptions instance) {
        this(fluent, instance, true);
    }

    public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.GetOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withResourceVersion(instance.getResourceVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptions instance) {
        this(instance,true);
    }

    public GetOptionsBuilder(io.fabric8.kubernetes.api.model.GetOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withResourceVersion(instance.getResourceVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.GetOptions build() {
        GetOptions buildable = new GetOptions(fluent.getApiVersion(),fluent.getKind(),fluent.getResourceVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GetOptionsBuilder that = (GetOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
