package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodeSelectorFluentImpl<A extends io.fabric8.kubernetes.api.model.NodeSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.NodeSelectorFluent<A> {

    private java.util.List<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> nodeSelectorTerms =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder>();

    public NodeSelectorFluentImpl() {
    }

    public NodeSelectorFluentImpl(io.fabric8.kubernetes.api.model.NodeSelector instance) {
        this.withNodeSelectorTerms(instance.getNodeSelectorTerms()); 
    }

    public A addToNodeSelectorTerms(int index,io.fabric8.kubernetes.api.model.NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder>();}
        io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(index >= 0 ? index : _visitables.get("nodeSelectorTerms").size(), builder);this.nodeSelectorTerms.add(index >= 0 ? index : nodeSelectorTerms.size(), builder); return (A)this;
    }

    public A setToNodeSelectorTerms(int index,io.fabric8.kubernetes.api.model.NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder>();}
        io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(item);
        if (index < 0 || index >= _visitables.get("nodeSelectorTerms").size()) { _visitables.get("nodeSelectorTerms").add(builder); } else { _visitables.get("nodeSelectorTerms").set(index, builder);}
        if (index < 0 || index >= nodeSelectorTerms.size()) { nodeSelectorTerms.add(builder); } else { nodeSelectorTerms.set(index, builder);}
         return (A)this;
    }

    public A addToNodeSelectorTerms(io.fabric8.kubernetes.api.model.NodeSelectorTerm... items) {
        if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder>();}
        for (io.fabric8.kubernetes.api.model.NodeSelectorTerm item : items) {io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(builder);this.nodeSelectorTerms.add(builder);} return (A)this;
    }

    public A addAllToNodeSelectorTerms(java.util.Collection<io.fabric8.kubernetes.api.model.NodeSelectorTerm> items) {
        if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder>();}
        for (io.fabric8.kubernetes.api.model.NodeSelectorTerm item : items) {io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(builder);this.nodeSelectorTerms.add(builder);} return (A)this;
    }

    public A removeFromNodeSelectorTerms(io.fabric8.kubernetes.api.model.NodeSelectorTerm... items) {
        for (io.fabric8.kubernetes.api.model.NodeSelectorTerm item : items) {io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").remove(builder);if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.remove(builder);}} return (A)this;
    }

    public A removeAllFromNodeSelectorTerms(java.util.Collection<io.fabric8.kubernetes.api.model.NodeSelectorTerm> items) {
        for (io.fabric8.kubernetes.api.model.NodeSelectorTerm item : items) {io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").remove(builder);if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNodeSelectorTerms(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> predicate) {
        if (nodeSelectorTerms == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> each = nodeSelectorTerms.iterator();
        final List visitables = _visitables.get("nodeSelectorTerms");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNodeSelectorTerms instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.NodeSelectorTerm> getNodeSelectorTerms() {
        return build(nodeSelectorTerms);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.NodeSelectorTerm> buildNodeSelectorTerms() {
        return build(nodeSelectorTerms);
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorTerm buildNodeSelectorTerm(int index) {
        return this.nodeSelectorTerms.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorTerm buildFirstNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorTerm buildLastNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(nodeSelectorTerms.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorTerm buildMatchingNodeSelectorTerm(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder item: nodeSelectorTerms) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingNodeSelectorTerm(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder item: nodeSelectorTerms) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNodeSelectorTerms(java.util.List<io.fabric8.kubernetes.api.model.NodeSelectorTerm> nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) { _visitables.get("nodeSelectorTerms").removeAll(this.nodeSelectorTerms);}
        if (nodeSelectorTerms != null) {this.nodeSelectorTerms = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder>(); for (io.fabric8.kubernetes.api.model.NodeSelectorTerm item : nodeSelectorTerms){this.addToNodeSelectorTerms(item);}} else { this.nodeSelectorTerms = null;} return (A) this;
    }

    public A withNodeSelectorTerms(io.fabric8.kubernetes.api.model.NodeSelectorTerm... nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.clear();}
        if (nodeSelectorTerms != null) {for (io.fabric8.kubernetes.api.model.NodeSelectorTerm item :nodeSelectorTerms){ this.addToNodeSelectorTerms(item);}} return (A) this;
    }

    public java.lang.Boolean hasNodeSelectorTerms() {
        return nodeSelectorTerms != null && !nodeSelectorTerms.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> addNewNodeSelectorTerm() {
        return new io.fabric8.kubernetes.api.model.NodeSelectorFluentImpl.NodeSelectorTermsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> addNewNodeSelectorTermLike(io.fabric8.kubernetes.api.model.NodeSelectorTerm item) {
        return new io.fabric8.kubernetes.api.model.NodeSelectorFluentImpl.NodeSelectorTermsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> setNewNodeSelectorTermLike(int index,io.fabric8.kubernetes.api.model.NodeSelectorTerm item) {
        return new io.fabric8.kubernetes.api.model.NodeSelectorFluentImpl.NodeSelectorTermsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> editNodeSelectorTerm(int index) {
        if (nodeSelectorTerms.size() <= index) throw new RuntimeException("Can't edit nodeSelectorTerms. Index exceeds size.");
        return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> editFirstNodeSelectorTerm() {
        if (nodeSelectorTerms.size() == 0) throw new RuntimeException("Can't edit first nodeSelectorTerms. The list is empty.");
        return setNewNodeSelectorTermLike(0, buildNodeSelectorTerm(0));
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> editLastNodeSelectorTerm() {
        int index = nodeSelectorTerms.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last nodeSelectorTerms. The list is empty.");
        return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<A> editMatchingNodeSelectorTerm(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> predicate) {
        int index = -1;
        for (int i=0;i<nodeSelectorTerms.size();i++) { 
        if (predicate.test(nodeSelectorTerms.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching nodeSelectorTerms. No match found.");
        return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodeSelectorFluentImpl that = (NodeSelectorFluentImpl) o;
        if (nodeSelectorTerms != null ? !nodeSelectorTerms.equals(that.nodeSelectorTerms) :that.nodeSelectorTerms != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(nodeSelectorTerms,  super.hashCode());
    }

    public class NodeSelectorTermsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeSelectorTermFluentImpl<io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<N>> implements io.fabric8.kubernetes.api.model.NodeSelectorFluent.NodeSelectorTermsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder builder;
        private final int index;

            NodeSelectorTermsNestedImpl(int index,io.fabric8.kubernetes.api.model.NodeSelectorTerm item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(this, item);
                        
            }

            NodeSelectorTermsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder(this);
                        
            }

            public N and() {
                return (N) NodeSelectorFluentImpl.this.setToNodeSelectorTerms(index,builder.build());
            }

            public N endNodeSelectorTerm() {
                return and();
            }
    }


}
