package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class EventFluentImpl<A extends io.fabric8.kubernetes.api.model.EventFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.EventFluent<A> {

    private java.lang.String action;
    private java.lang.String apiVersion;
    private java.lang.Integer count;
    private io.fabric8.kubernetes.api.model.MicroTimeBuilder eventTime;
    private java.lang.String firstTimestamp;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder involvedObject;
    private java.lang.String kind;
    private java.lang.String lastTimestamp;
    private java.lang.String message;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.lang.String reason;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder related;
    private java.lang.String reportingComponent;
    private java.lang.String reportingInstance;
    private io.fabric8.kubernetes.api.model.EventSeriesBuilder series;
    private io.fabric8.kubernetes.api.model.EventSourceBuilder source;
    private java.lang.String type;

    public EventFluentImpl() {
    }

    public EventFluentImpl(io.fabric8.kubernetes.api.model.Event instance) {
        this.withAction(instance.getAction()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withCount(instance.getCount()); 
        this.withEventTime(instance.getEventTime()); 
        this.withFirstTimestamp(instance.getFirstTimestamp()); 
        this.withInvolvedObject(instance.getInvolvedObject()); 
        this.withKind(instance.getKind()); 
        this.withLastTimestamp(instance.getLastTimestamp()); 
        this.withMessage(instance.getMessage()); 
        this.withMetadata(instance.getMetadata()); 
        this.withReason(instance.getReason()); 
        this.withRelated(instance.getRelated()); 
        this.withReportingComponent(instance.getReportingComponent()); 
        this.withReportingInstance(instance.getReportingInstance()); 
        this.withSeries(instance.getSeries()); 
        this.withSource(instance.getSource()); 
        this.withType(instance.getType()); 
    }

    public java.lang.String getAction() {
        return this.action;
    }

    public A withAction(java.lang.String action) {
        this.action=action; return (A) this;
    }

    public java.lang.Boolean hasAction() {
        return this.action != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAction instead.
     */
        public A withNewAction(java.lang.String arg0) {
        return (A)withAction(new String(arg0));
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.Integer getCount() {
        return this.count;
    }

    public A withCount(java.lang.Integer count) {
        this.count=count; return (A) this;
    }

    public java.lang.Boolean hasCount() {
        return this.count != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEventTime instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.MicroTime getEventTime() {
        return this.eventTime!=null?this.eventTime.build():null;
    }

    public io.fabric8.kubernetes.api.model.MicroTime buildEventTime() {
        return this.eventTime!=null?this.eventTime.build():null;
    }

    public A withEventTime(io.fabric8.kubernetes.api.model.MicroTime eventTime) {
        _visitables.get("eventTime").remove(this.eventTime);
        if (eventTime!=null){ this.eventTime= new io.fabric8.kubernetes.api.model.MicroTimeBuilder(eventTime); _visitables.get("eventTime").add(this.eventTime);} return (A) this;
    }

    public java.lang.Boolean hasEventTime() {
        return this.eventTime != null;
    }

    public A withNewEventTime(java.lang.String time) {
        return (A)withEventTime(new MicroTime(time));
    }

    public io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<A> withNewEventTime() {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.EventTimeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<A> withNewEventTimeLike(io.fabric8.kubernetes.api.model.MicroTime item) {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.EventTimeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<A> editEventTime() {
        return withNewEventTimeLike(getEventTime());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<A> editOrNewEventTime() {
        return withNewEventTimeLike(getEventTime() != null ? getEventTime(): new io.fabric8.kubernetes.api.model.MicroTimeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<A> editOrNewEventTimeLike(io.fabric8.kubernetes.api.model.MicroTime item) {
        return withNewEventTimeLike(getEventTime() != null ? getEventTime(): item);
    }

    public java.lang.String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public A withFirstTimestamp(java.lang.String firstTimestamp) {
        this.firstTimestamp=firstTimestamp; return (A) this;
    }

    public java.lang.Boolean hasFirstTimestamp() {
        return this.firstTimestamp != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFirstTimestamp instead.
     */
        public A withNewFirstTimestamp(java.lang.String arg0) {
        return (A)withFirstTimestamp(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildInvolvedObject instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getInvolvedObject() {
        return this.involvedObject!=null?this.involvedObject.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildInvolvedObject() {
        return this.involvedObject!=null?this.involvedObject.build():null;
    }

    public A withInvolvedObject(io.fabric8.kubernetes.api.model.ObjectReference involvedObject) {
        _visitables.get("involvedObject").remove(this.involvedObject);
        if (involvedObject!=null){ this.involvedObject= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(involvedObject); _visitables.get("involvedObject").add(this.involvedObject);} return (A) this;
    }

    public java.lang.Boolean hasInvolvedObject() {
        return this.involvedObject != null;
    }

    public io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<A> withNewInvolvedObject() {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.InvolvedObjectNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.InvolvedObjectNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<A> editInvolvedObject() {
        return withNewInvolvedObjectLike(getInvolvedObject());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject() {
        return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewInvolvedObjectLike(getInvolvedObject() != null ? getInvolvedObject(): item);
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    public java.lang.String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public A withLastTimestamp(java.lang.String lastTimestamp) {
        this.lastTimestamp=lastTimestamp; return (A) this;
    }

    public java.lang.Boolean hasLastTimestamp() {
        return this.lastTimestamp != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLastTimestamp instead.
     */
        public A withNewLastTimestamp(java.lang.String arg0) {
        return (A)withLastTimestamp(new String(arg0));
    }

    public java.lang.String getMessage() {
        return this.message;
    }

    public A withMessage(java.lang.String message) {
        this.message=message; return (A) this;
    }

    public java.lang.Boolean hasMessage() {
        return this.message != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMessage instead.
     */
        public A withNewMessage(java.lang.String arg0) {
        return (A)withMessage(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public java.lang.String getReason() {
        return this.reason;
    }

    public A withReason(java.lang.String reason) {
        this.reason=reason; return (A) this;
    }

    public java.lang.Boolean hasReason() {
        return this.reason != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withReason instead.
     */
        public A withNewReason(java.lang.String arg0) {
        return (A)withReason(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRelated instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getRelated() {
        return this.related!=null?this.related.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildRelated() {
        return this.related!=null?this.related.build():null;
    }

    public A withRelated(io.fabric8.kubernetes.api.model.ObjectReference related) {
        _visitables.get("related").remove(this.related);
        if (related!=null){ this.related= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(related); _visitables.get("related").add(this.related);} return (A) this;
    }

    public java.lang.Boolean hasRelated() {
        return this.related != null;
    }

    public io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<A> withNewRelated() {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.RelatedNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<A> withNewRelatedLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.RelatedNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<A> editRelated() {
        return withNewRelatedLike(getRelated());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<A> editOrNewRelated() {
        return withNewRelatedLike(getRelated() != null ? getRelated(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<A> editOrNewRelatedLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewRelatedLike(getRelated() != null ? getRelated(): item);
    }

    public java.lang.String getReportingComponent() {
        return this.reportingComponent;
    }

    public A withReportingComponent(java.lang.String reportingComponent) {
        this.reportingComponent=reportingComponent; return (A) this;
    }

    public java.lang.Boolean hasReportingComponent() {
        return this.reportingComponent != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withReportingComponent instead.
     */
        public A withNewReportingComponent(java.lang.String arg0) {
        return (A)withReportingComponent(new String(arg0));
    }

    public java.lang.String getReportingInstance() {
        return this.reportingInstance;
    }

    public A withReportingInstance(java.lang.String reportingInstance) {
        this.reportingInstance=reportingInstance; return (A) this;
    }

    public java.lang.Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withReportingInstance instead.
     */
        public A withNewReportingInstance(java.lang.String arg0) {
        return (A)withReportingInstance(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSeries instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.EventSeries getSeries() {
        return this.series!=null?this.series.build():null;
    }

    public io.fabric8.kubernetes.api.model.EventSeries buildSeries() {
        return this.series!=null?this.series.build():null;
    }

    public A withSeries(io.fabric8.kubernetes.api.model.EventSeries series) {
        _visitables.get("series").remove(this.series);
        if (series!=null){ this.series= new io.fabric8.kubernetes.api.model.EventSeriesBuilder(series); _visitables.get("series").add(this.series);} return (A) this;
    }

    public java.lang.Boolean hasSeries() {
        return this.series != null;
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<A> withNewSeries() {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.SeriesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<A> withNewSeriesLike(io.fabric8.kubernetes.api.model.EventSeries item) {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.SeriesNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<A> editSeries() {
        return withNewSeriesLike(getSeries());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<A> editOrNewSeries() {
        return withNewSeriesLike(getSeries() != null ? getSeries(): new io.fabric8.kubernetes.api.model.EventSeriesBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<A> editOrNewSeriesLike(io.fabric8.kubernetes.api.model.EventSeries item) {
        return withNewSeriesLike(getSeries() != null ? getSeries(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSource instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.EventSource getSource() {
        return this.source!=null?this.source.build():null;
    }

    public io.fabric8.kubernetes.api.model.EventSource buildSource() {
        return this.source!=null?this.source.build():null;
    }

    public A withSource(io.fabric8.kubernetes.api.model.EventSource source) {
        _visitables.get("source").remove(this.source);
        if (source!=null){ this.source= new io.fabric8.kubernetes.api.model.EventSourceBuilder(source); _visitables.get("source").add(this.source);} return (A) this;
    }

    public java.lang.Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(java.lang.String component,java.lang.String host) {
        return (A)withSource(new EventSource(component, host));
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SourceNested<A> withNewSource() {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.SourceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SourceNested<A> withNewSourceLike(io.fabric8.kubernetes.api.model.EventSource item) {
        return new io.fabric8.kubernetes.api.model.EventFluentImpl.SourceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SourceNested<A> editSource() {
        return withNewSourceLike(getSource());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SourceNested<A> editOrNewSource() {
        return withNewSourceLike(getSource() != null ? getSource(): new io.fabric8.kubernetes.api.model.EventSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.EventFluent.SourceNested<A> editOrNewSourceLike(io.fabric8.kubernetes.api.model.EventSource item) {
        return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    public java.lang.String getType() {
        return this.type;
    }

    public A withType(java.lang.String type) {
        this.type=type; return (A) this;
    }

    public java.lang.Boolean hasType() {
        return this.type != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withType instead.
     */
        public A withNewType(java.lang.String arg0) {
        return (A)withType(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventFluentImpl that = (EventFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (count != null ? !count.equals(that.count) :that.count != null) return false;
        if (eventTime != null ? !eventTime.equals(that.eventTime) :that.eventTime != null) return false;
        if (firstTimestamp != null ? !firstTimestamp.equals(that.firstTimestamp) :that.firstTimestamp != null) return false;
        if (involvedObject != null ? !involvedObject.equals(that.involvedObject) :that.involvedObject != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (lastTimestamp != null ? !lastTimestamp.equals(that.lastTimestamp) :that.lastTimestamp != null) return false;
        if (message != null ? !message.equals(that.message) :that.message != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (related != null ? !related.equals(that.related) :that.related != null) return false;
        if (reportingComponent != null ? !reportingComponent.equals(that.reportingComponent) :that.reportingComponent != null) return false;
        if (reportingInstance != null ? !reportingInstance.equals(that.reportingInstance) :that.reportingInstance != null) return false;
        if (series != null ? !series.equals(that.series) :that.series != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  apiVersion,  count,  eventTime,  firstTimestamp,  involvedObject,  kind,  lastTimestamp,  message,  metadata,  reason,  related,  reportingComponent,  reportingInstance,  series,  source,  type,  super.hashCode());
    }

    public class EventTimeNestedImpl<N> extends io.fabric8.kubernetes.api.model.MicroTimeFluentImpl<io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<N>> implements io.fabric8.kubernetes.api.model.EventFluent.EventTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.MicroTimeBuilder builder;

            EventTimeNestedImpl(io.fabric8.kubernetes.api.model.MicroTime item) {
                this.builder = new io.fabric8.kubernetes.api.model.MicroTimeBuilder(this, item);
                        
            }

            EventTimeNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.MicroTimeBuilder(this);
                        
            }

            public N and() {
                return (N) EventFluentImpl.this.withEventTime(builder.build());
            }

            public N endEventTime() {
                return and();
            }
    }


    public class InvolvedObjectNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<N>> implements io.fabric8.kubernetes.api.model.EventFluent.InvolvedObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            InvolvedObjectNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            InvolvedObjectNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) EventFluentImpl.this.withInvolvedObject(builder.build());
            }

            public N endInvolvedObject() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.EventFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) EventFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class RelatedNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<N>> implements io.fabric8.kubernetes.api.model.EventFluent.RelatedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            RelatedNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            RelatedNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) EventFluentImpl.this.withRelated(builder.build());
            }

            public N endRelated() {
                return and();
            }
    }


    public class SeriesNestedImpl<N> extends io.fabric8.kubernetes.api.model.EventSeriesFluentImpl<io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<N>> implements io.fabric8.kubernetes.api.model.EventFluent.SeriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.EventSeriesBuilder builder;

            SeriesNestedImpl(io.fabric8.kubernetes.api.model.EventSeries item) {
                this.builder = new io.fabric8.kubernetes.api.model.EventSeriesBuilder(this, item);
                        
            }

            SeriesNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.EventSeriesBuilder(this);
                        
            }

            public N and() {
                return (N) EventFluentImpl.this.withSeries(builder.build());
            }

            public N endSeries() {
                return and();
            }
    }


    public class SourceNestedImpl<N> extends io.fabric8.kubernetes.api.model.EventSourceFluentImpl<io.fabric8.kubernetes.api.model.EventFluent.SourceNested<N>> implements io.fabric8.kubernetes.api.model.EventFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.EventSourceBuilder builder;

            SourceNestedImpl(io.fabric8.kubernetes.api.model.EventSource item) {
                this.builder = new io.fabric8.kubernetes.api.model.EventSourceBuilder(this, item);
                        
            }

            SourceNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.EventSourceBuilder(this);
                        
            }

            public N and() {
                return (N) EventFluentImpl.this.withSource(builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
